clc ; clear ; 

% Values for maize
psicolar=-4000;
psitop=-3000;
psibottom=-0;

WD = pwd;

addpath(genpath(WD));

RootSys = [WD,'/in/RootSys_singlerootcompfibrous']; %single root
CR=[WD,'/in/CondRoot_singleroot.in'];

[tip,seg,age,] = read_rootsys(RootSys);
[tip,seg] = change_order(tip,seg);

IM_old = construct_IM(seg);

[Kr,Kx,kr,kx] = condroot2K(CR,seg,max(max(seg(:,end)),age));


nrootseg=length(Kr);

seg_age = age-seg(:,end);

IM=[[IM_old(2:end,1:nrootseg),diag(sparse(-ones(nrootseg,1)))];[sparse(zeros(nrootseg,nrootseg)),diag(sparse(ones(nrootseg,1)))]];

figure (1);
draw_root(RootSys,1)

figure (2)
subplot(1,2,1)
hold on
box on
subplot(1,2,2)
hold on
box on

C={'b','k'};

for i = 1:2
    pos = find(seg(:,6)==i);
    
    kr_temp=kr(pos);
    kx_temp=kx(pos);
    
    [s_age_sorted,ord]=sort(seg_age(pos));
    subplot(1,2,1)
    plot(s_age_sorted,log10(kr_temp(ord)),'--','color',C{i})
    xlabel('age (d)')
    ylabel('log10 kr (1/d)')
    subplot(1,2,2)
    plot(s_age_sorted,log10(kx_temp(ord)),'--','color',C{i})
    ylabel('log10 kx (cm/d)')
    xlabel('age (d)')
    legend('order #1', 'order #2')
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Collar_connect = zeros(1,nrootseg);
Collar_connect(seg(:,5)==0)=-1;

IMT=cat(2,[Collar_connect,zeros(1,nrootseg)]',transpose(IM));

K=diag(sparse([Kx;Kr]));
C=IM*K*IMT;
C1=C(1:nrootseg,1);
C2=C(1:nrootseg,2:nrootseg+1);
C3=C(1:nrootseg,nrootseg+2:2*nrootseg+1);
t = mldivide(C2,C3);

clear C;
clear IM;
clear IMT;


C4=K(nrootseg+1:2*nrootseg,nrootseg+1:2*nrootseg)*(speye(nrootseg)+t);

s = mldivide(C2,C1);
C5=K(nrootseg+1:2*nrootseg,nrootseg+1:2*nrootseg)*s;
Krs=sum(sum(C4));
SUF=-C5/Krs;

clear t;
clear s;
clear C2;
clear C3;
clear K;

zbottom=floor(min(seg(:,4)));

psis1=0.0*ones(nrootseg,1);
psis1=psibottom+(seg(:,4)-zbottom)*(psitop-psibottom)/(-zbottom);

psieff=SUF'*psis1;

C6=C4-Krs*sparse(SUF*SUF');

sinkdoussan3=C6*(psis1-ones(nrootseg,1)*SUF'*psis1)+Krs.*SUF.*(SUF'*psis1-psicolar);

sufcomp=zeros(nrootseg);
for i=1:nrootseg
    sufcomp(i,:)=C6(i,:)/C6(i,i);
    kcompcouvreur(i,i)=C6(i,i)/SUF(i)/(1-SUF(i));
    kcompcouvreur_mat(i,1)=kcompcouvreur(i,i);
end

clear C4;

C7=sparse(diag(1-SUF))*sufcomp+ones(nrootseg).*SUF';

sinkcouvreur=Krs*SUF*(SUF'*psis1-psicolar)+...
    kcompcouvreur*diag(SUF)*C7*(psis1-ones(nrootseg,1)*SUF'*psis1);

figure (3);
hist(log10(kcompcouvreur_mat),100);
hold on
line(log10([Krs Krs]),get(gca,'YLim'),'Color',[1 0 0])
xlabel('log10K_{comp}')



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%upscaling
dz=2;
ndepths=abs(floor(min(seg(:,4))/dz));
C6upscale=zeros(ndepths);
C7upscale=zeros(ndepths);

SUFupscale=zeros(ndepths,1);
kcompcouvreurupscale=zeros(ndepths);
sufcompupscale=zeros(ndepths);
psiupscale=zeros(ndepths,1);
sinkupscale2=zeros(ndepths,1);


for i=1:ndepths
    zup=-(i-1)*dz;
    zlow=-i*dz;
    mask1=seg(:,4)>=zlow & seg(:,4)<zup;
    SUFupscale(i)=sum(SUF(mask1),'double');
    psiupscale(i)=SUF(mask1)'*psis1(mask1)/sum(SUF(mask1));
    sinkupscale2(i)=sum(sinkdoussan3(mask1));
  for j=1:ndepths
    zup2=-(j-1)*dz;
    zlow2=-j*dz;
    mask2=seg(:,4)>=zlow2 & seg(:,4)<zup2;
    C6upscale(i,j)=sum(sum(C6(mask1,mask2)));
  end
  sufcompupscale(i,:)=C6upscale(i,:)/C6upscale(i,i);
  kcompcouvreurupscale(i,i)=C6upscale(i,i)/SUFupscale(i)/(1-SUFupscale(i));
  kcompcouvreurupscaleplot(i,1)=kcompcouvreurupscale(i,i);
end
C7upscale=diag(1-SUFupscale)*sufcompupscale+ones(ndepths).*SUFupscale';

C7upscaleimage=C7upscale;
C7upscaleimage(C7upscale==1)=0;

depths=(-dz/2:-dz:-(ndepths-1)*dz-dz/2)';

figure (4);
subplot(2,1,1)
imagesc(C7upscaleimage)
title('C7 matrix')
colorbar
subplot(2,1,2)
semilogy(depths,kcompcouvreurupscaleplot/Krs)
xlabel('depth')
ylabel('Kcomp/Krs')

psieffupscale=SUFupscale'*psiupscale;
sinkupscale=C6upscale*(psiupscale-ones(ndepths,1)*psieffupscale)...
    +Krs.*SUFupscale.*(psieffupscale-psicolar);
sinkupscaleparallel=Krs.*SUFupscale.*(psiupscale-ones(ndepths,1)*psieffupscale)+...
    Krs.*SUFupscale.*(psieffupscale-psicolar);

deltasinkupscale=sinkupscale-SUFupscale.*Krs.*(SUFupscale'*psiupscale-psicolar);
deltasinkupscaleparallel=sinkupscaleparallel-...
Krs.*SUFupscale.*(psieffupscale-psicolar);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Big root approximation for upscaled root water uptake
IMbigroot=zeros(2*ndepths);

for i=1:ndepths-1
    IMbigroot(i,i)=1;
    IMbigroot(i+ndepths,i+ndepths)=1;
    IMbigroot(i,i+1)=-1;
    IMbigroot(i,ndepths+i)=-1;
end
IMbigroot(ndepths,ndepths)=1;
IMbigroot(ndepths,2*ndepths)=-1;
IMbigroot(2*ndepths,2*ndepths)=1;

dummy=[-1;zeros(2*ndepths-1,1)];
IMTbigroot=cat(2,dummy,transpose(IMbigroot));

Kbigrootkxfit=zeros(2*ndepths);
Kbigrootkrfit=zeros(2*ndepths);
Kbigrootnofit=zeros(2*ndepths);

%%%%%%%%%
segdz=zeros(nrootseg,1);
for i=1:nrootseg
    zseg=seg(i,4);
    upnode=seg(i,5);
    if upnode>0
        segdz(i)=zseg-seg(upnode,4);
    else
        segdz(i)=zseg;
    end
end
%%%%%%%

for i=1:ndepths
    zup=-(i-1)*dz;
    zlow=-i*dz;
    mask1=seg(:,4)>=zlow & seg(:,4)<zup;
        
    totlength=sum(seg(mask1,8),'double');
    kxw=sum(abs(segdz(mask1)).*kx(mask1),'double')/totlength;
    Kbigrootnofit(i,i)=kxw*sum(abs(segdz(mask1)),'double')/(zup-zlow)^2;
    Kbigrootnofit(ndepths+i,ndepths+i)=sum(Kr(mask1),'double');
    
end    

sufkrsbigrootnofit=sufkrs(Kbigrootnofit,IMbigroot,IMTbigroot,ndepths);

[sinkbigrootnofit,deltasinkbigrootnofit]=sinkterm(Kbigrootnofit,IMbigroot,IMTbigroot,ndepths,psiupscale,psicolar);

%%%%%%parallel root system infinite Kx

sufkxinf=SUFupscale*0;
denom=sum(Kbigrootnofit(ndepths+1:2*ndepths,ndepths+1:2*ndepths),'all');
for i=1:ndepths
    sufkxinf(i)=Kbigrootnofit(ndepths+i,ndepths+i)/denom;
end


psieffupscalekxinf=sufkxinf'*psiupscale; 
sinkkxinf=Krs.*sufkxinf.*(psiupscale-ones(ndepths,1)*psieffupscalekxinf)+...
    Krs.*sufkxinf.*(psieffupscalekxinf-psicolar);


figure (5);

%subplot(2,1,2)
%yyaxis left
plot(depths,sinkupscale/dz,depths,sinkupscaleparallel/dz,'c--o', ...
    depths,sinkbigrootnofit/dz,'m:x',depths,sinkkxinf/dz,'g-.v');
xlabel('depth (cm)')
ylabel('sink term (cm/d)')
legend('sink exact','sink parallel root','sink big root','sink parallel root inf Kx')


figure (6);
%yyaxis right
%subplot(2,1,1)
plot(depths,SUFupscale,depths,sufkrsbigrootnofit(1:ndepths),'mx',...
    depths,sufkxinf,'gv')
ylabel('SUF')
legend('SUF','SUF big root','SUF parallel root inf Kx')

