clear;

ra=0.1;
rs=1;
nrootseg=9;

% Doussan solution

IM=...
[1	-1	0	0	0	0	0	0	0	-1	0	0	0	0	0	0	0	0;...
0	1	0	0	0	0	0	0	0	0	-1	0	0	0	0	0	0	0;...
0	0	1	-1	0	0	0	0	0	0	0	-1	0	0	0	0	0	0;...
0	0	0	1	-1	0	0	0	0	0	0	0	-1	0	0	0	0	0;...
0	0	0	0	1	0	0	0	0	0	0	0	0	-1	0	0	0	0;...
0	0	0	0	0	1	-1	0	0	0	0	0	0	0	-1	0	0	0;...
0	0	0	0	0	0	1	-1	0	0	0	0	0	0	0	-1	0	0;...
0	0	0	0	0	0	0	1	-1	0	0	0	0	0	0	0	-1	0;...
0	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	-1;...
0	0	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0;...
0	0	0	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0;...
0	0	0	0	0	0	0	0	0	0	0	1	0	0	0	0	0	0;...
0	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0	0	0;...
0	0	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0	0;...
0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0;...
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	0	0;...
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1	0;...
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	1];



IMT=cat(2,[-1;0;-1;0;0;-1;0;0;0;0;0;0;0;0;0;0;0;0],transpose(IM));


K=diag([1/ra 1/ra 1/ra 1/ra 1/ra 1/ra 1/ra 1/ra 1/ra...
    0.1/rs 1/rs 0.1/rs 0.1/rs 1/rs 0.1/rs 0.1/rs 0.1/rs 1/rs]);


C=IM*K*IMT;
C1=C(1:nrootseg,1);
C2=C(1:nrootseg,2:nrootseg+1);
C3=C(1:nrootseg,nrootseg+2:2*nrootseg+1);
C4=K(nrootseg+1:2*nrootseg,nrootseg+1:2*nrootseg)*(eye(nrootseg)+...
inv(C2)*C3);

C5=K(nrootseg+1:2*nrootseg,nrootseg+1:2*nrootseg)*inv(C2)*C1;
Krs=sum(sum(C4));
SUF=-C5/Krs;


psicolar=-1;
psis1=[-0.5;0;-0.5;0;0.5;-0.5;0;0.5;1];




C6=C4-Krs*SUF*SUF';

sufcomp=C6*0;
for i=1:nrootseg
    sufcomp(i,:)=C6(i,:)/C6(i,i);
    kcompcouvreur(i,i)=C6(i,i)/SUF(i)/(1-SUF(i));
end
C7=diag(1-SUF)*sufcomp+ones(nrootseg).*SUF';

sinkcouvreur=Krs*SUF*(SUF'*psis1-psicolar)+...
    kcompcouvreur*diag(SUF)*C7*(psis1-ones(nrootseg,1)*SUF'*psis1);


depth1=[1,3,6];
depth2=[2,4,7];
depth3=[5,8];
depth4=[9];
tabledepth=table(depth1,depth2,depth3,depth4);

ndepths=4;
C6upscale=zeros(ndepths);

SUFupscale=zeros(ndepths,1);
kcompcouvreurupscale=zeros(ndepths);
sufcompupscale=zeros(ndepths);
psiupscale=zeros(ndepths,1);
sinkupscale2=zeros(ndepths,1);

for i=1:ndepths
    SUFupscale(i)=sum(SUF(table2array(tabledepth(1,i))));
        psiupscale(i)=SUF(table2array(tabledepth(1,i)))'*psis1(table2array(tabledepth(1,i)))...
        /sum(SUF(table2array(tabledepth(1,i))));
  for j=1:ndepths
      C6upscale(i,j)=sum(sum(C6(table2array(tabledepth(1,i)),table2array(tabledepth(1,j)))));
  end
end

sinkupscale=C6upscale*(psiupscale-ones(ndepths,1)*SUFupscale'*psiupscale)...
    +Krs.*SUFupscale.*(SUFupscale'*psiupscale-psicolar);

deltasinkupscale=sinkupscale-SUFupscale.*Krs.*(SUFupscale'*psiupscale-psicolar);


sinkcouvreurupscaleapprox=Krs*SUFupscale*(SUFupscale'*psiupscale-psicolar)+...
    Krs*SUFupscale.*(psiupscale-SUFupscale'*psiupscale);

deltasinkcouvreurupscaleapprox=sinkcouvreurupscaleapprox-SUFupscale.*Krs.*(SUFupscale'*psiupscale-psicolar);

deltapsiupscale=psiupscale-SUFupscale'*psiupscale;

for i=1:ndepths
    sufcompupscale(i,:)=C6upscale(i,:)/C6upscale(i,i);
    kcompcouvreurupscale(i,i)=C6upscale(i,i)/SUFupscale(i)/(1-SUFupscale(i));
end
C7upscale=diag(1-SUFupscale)*sufcompupscale+ones(ndepths).*SUFupscale';




%Big root approximation for upscaled root water uptake

IMbigroot=...
[1,-1,0,0,-1,0,0,0;...
0,1,-1,0,0,-1,0,0;...
0,0,1,-1,0,0,-1,0;...
0,0,0,1,0,0,0,-1;...
0,0,0,0,1,0,0,0,;...
0,0,0,0,0,1,0,0;...
0,0,0,0,0,0,1,0;...
0,0,0,0,0,0,0,1];

IMTbigroot=cat(2,[-1;0;0;0;0;0;0;0],transpose(IMbigroot));
Kbigroot= diag([3/ra 3/ra 2/ra 1/ra...
    0.3/rs (1/rs+0.2/rs) (1/rs+0.1/rs) 1/rs]);

Cbigroot=IMbigroot*Kbigroot*IMTbigroot;
C1bigroot=Cbigroot(1:ndepths,1);
C2bigroot=Cbigroot(1:ndepths,2:ndepths+1);
C3bigroot=Cbigroot(1:ndepths,ndepths+2:2*ndepths+1);
C4bigroot=Kbigroot(ndepths+1:2*ndepths,ndepths+1:2*ndepths)*(eye(ndepths)+...
inv(C2bigroot)*C3bigroot);
Krsbigroot=sum(sum(C4bigroot));

C5bigroot=Kbigroot(ndepths+1:2*ndepths,ndepths+1:2*ndepths)*inv(C2bigroot)*C1bigroot;
SUFbigroot=-C5bigroot/Krsbigroot;
C6bigroot=C4bigroot-Krsbigroot*SUFbigroot*SUFbigroot';
sufcompbigroot=C6bigroot*0;
kcompbigroot=C6bigroot*0;
for i=1:ndepths
    sufcompbigroot(i,:)=C6bigroot(i,:)/C6bigroot(i,i); 
end
C7bigroot=diag(1-SUFbigroot)*sufcompbigroot+ones(ndepths).*SUFbigroot';
sinkbigroot=C6bigroot*(psiupscale-ones(ndepths,1)*SUFbigroot'*psiupscale)+Krsbigroot.*SUFbigroot.*(SUFbigroot'*psiupscale-psicolar);
deltasinkbigroot=C6bigroot*(psiupscale-ones(ndepths,1)*SUFbigroot'*psiupscale);


%Parallel root approximation assuming infinite kx

%sufinfkx=[3;3;2;1]/sum([3;3;2;1]);
sufinfkx=[0.3;1.2;1.1;1]/sum([0.3;1.2;1.1;1]);

sinkinfkx=Krs*sufinfkx.*(sufinfkx'*psiupscale-psicolar)+...
    Krs*sufinfkx.*(psiupscale-sufinfkx'*psiupscale);
deltasinkinfkx= Krs*sufinfkx.*(psiupscale-sufinfkx'*psiupscale);

figure (1);
title('Kx=10, Kr=0.1 (1.0 at root tips), hybrid parallel-big root')
yyaxis left;
plot(-1*(1:4),deltasinkupscale,'b',-1*(1:4),deltasinkcouvreurupscaleapprox,'c-',...
    -1*(1:4),deltasinkbigroot,'m--',-1*(1:4),deltasinkinfkx,'g-.');
xlabel('depth');
ylabel('delta sink')
yyaxis right;
plot(-1*(1:4),psiupscale,'r');
ylabel('soil water potential')
legend('Exact','Parallel root approx','Big root approx','Parallel root approx, inf kx')

figure (2);
title('Kx=10, Kr=0.1 (1.0 at root tips), hybrid parallel-big root')
yyaxis left;
plot(-1*(1:4),sinkupscale,'b',-1*(1:4),sinkcouvreurupscaleapprox,'c-',...
    -1*(1:4),sinkbigroot,'m--',-1*(1:4),sinkinfkx,'g-.');
xlabel('depth');
ylabel('water uptake Q')
yyaxis right;
plot(-1*(1:4),psiupscale,'r');
ylabel('soil water potential')
legend('Exact','Parallel root approx','Big root approx','Parallel root approx, inf kx')


figure (3);
title('Kx=10, Kr=0.1 (1.0 at root tips), hybrid parallel-big root')
yyaxis left;
plot(-1*(1:4),SUFupscale,'b',...
    -1*(1:4),SUFbigroot,'m--',-1*(1:4),sufinfkx,'g-.');
xlabel('depth');
ylabel('SUF')
yyaxis right;
plot(-1*(1:4),psiupscale,'r');
ylabel('soil water potential')
legend('Exact-parallel root approx','Big root approx','Parallel root approx, inf kx')