
##################### test GR ###################
rm(list = ls())
library(airGR)
library(caRamel)

## loading catchment data
data(L0123001)

## preparation of the InputsModel object
InputsModel <- CreateInputsModel(FUN_MOD = RunModel_GR4J, DatesR = BasinObs$DatesR, 
                                 Precip = BasinObs$P, PotEvap = BasinObs$E)

## run period selection
Ind_Run <- seq(which(format(BasinObs$DatesR, format = "%Y-%m-%d")=="1990-01-01"), 
               which(format(BasinObs$DatesR, format = "%Y-%m-%d")=="1999-12-31"))

## preparation of the RunOptions object
RunOptions <- CreateRunOptions(FUN_MOD = RunModel_GR4J,
                               InputsModel = InputsModel, IndPeriod_Run = Ind_Run)

## single efficiency criterion: KGE
InputsCrit <- CreateInputsCrit(FUN_CRIT = ErrorCrit_KGE,
                                     InputsModel = InputsModel, RunOptions = RunOptions,
                                     Obs = list(BasinObs$Qmm[Ind_Run]),
                                     VarObs = "Q", transfo = "",
                                     Weights = NULL)
## single efficiency criterion: KGE sqrt
InputsCrit2 <- CreateInputsCrit(FUN_CRIT = ErrorCrit_KGE,
                                     InputsModel = InputsModel, RunOptions = RunOptions,
                                     Obs = list(BasinObs$Qmm[Ind_Run]),
                                     VarObs = "Q", transfo = "sqrt",
                                     Weights = NULL)

InitGR<-function(cl,numcores){
  parLapply( cl, 1:numcores, function(xx){require('airGR')})
  clusterExport(cl=cl, varlist=c("InputsModel", "RunOptions", "InputsCrit", "InputsCrit2")) 
}

EvalGR <- function(i){## Transformation of the parameter set to real space
  RawParamOptim <- airGR::TransfoParam_GR4J(ParamIn = x[i,],
                                            Direction = "TR")
  ## Simulation given a parameter set
  OutputsModel <- airGR::RunModel_GR4J(InputsModel = InputsModel,
                                       RunOptions = RunOptions,
                                       Param = RawParamOptim)
  ## Computation of the value of the performance criteria
  OutputsCrit <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit,
                                      OutputsModel = OutputsModel,
                                      verbose = FALSE)
  ## Computation of the value of the performance criteria
  OutputsCrit2 <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit2,
                                       OutputsModel = OutputsModel,
                                       verbose = FALSE)
  return(c(OutputsCrit$CritValue, OutputsCrit2$CritValue) )
}

# definition of the bounds of parameters (between -9.99 and 9.99)
# the parameter values will be transformed to actual parameter values in EvalGR
bounds <- matrix(c(rep(-9.99, 4),rep(9.99, 4)), ncol = 2) 

results  <-  caRamel(nobj = 2, nvar = 4, minmax = rep(TRUE,2), bounds = bounds, func = EvalGR, 
                     funcinit = InitGR, popsize = 100, archsize = 100, maxrun = 15000, 
                     prec = rep(1.e-4,2) )

Param_temp <- results$parameters[round(dim(results$parameters)[1]/2),] #choosing a kind of median parameter set
Param <- airGR::TransfoParam_GR4J(ParamIn = Param_temp, Direction = "TR") # transforming back to actual parameter values
## Simulation given the optimised parameter set
OutputsModel <- airGR::RunModel_GR4J(InputsModel = InputsModel,
                                     RunOptions = RunOptions,
                                     Param = Param)
## Computation of the value of the performance criteria
OutputsCrit <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit,
                                    OutputsModel = OutputsModel,
                                    verbose = FALSE)## Computation of the value of the performance criteria
OutputsCrit2 <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit2,
                                     OutputsModel = OutputsModel,
                                     verbose = FALSE)
print(c(OutputsCrit$CritValue, OutputsCrit2$CritValue))








############### comparison the airGR calibration (Calibration_Michel) and a composite OF ######

rm(list = ls())
library(airGR)

## loading catchment data
data(L0123001)

## preparation of the InputsModel object
InputsModel <- CreateInputsModel(FUN_MOD = RunModel_GR4J, DatesR = BasinObs$DatesR, 
                                 Precip = BasinObs$P, PotEvap = BasinObs$E)

## run period selection
Ind_Run <- seq(which(format(BasinObs$DatesR, format = "%Y-%m-%d")=="1990-01-01"), 
               which(format(BasinObs$DatesR, format = "%Y-%m-%d")=="1999-12-31"))

## preparation of the RunOptions object
RunOptions <- CreateRunOptions(FUN_MOD = RunModel_GR4J,
                               InputsModel = InputsModel, IndPeriod_Run = Ind_Run)

## efficiency composite criterion: KGE mixing
##                                 both raw and sqrt-transformed flows
InputsCritCompo <- CreateInputsCrit(FUN_CRIT = list(ErrorCrit_KGE, ErrorCrit_KGE),
                                    InputsModel = InputsModel, RunOptions = RunOptions,
                                    Obs = list(BasinObs$Qmm[Ind_Run], BasinObs$Qmm[Ind_Run]),
                                    VarObs = list("Q", "Q"), transfo = list("", "sqrt"),
                                    Weights = list(0.5, 0.5))

## preparation of CalibOptions object
CalibOptions <- CreateCalibOptions(FUN_MOD = RunModel_GR4J, FUN_CALIB = Calibration_Michel)

## calibration
start_time <- Sys.time()
OutputsCalib <- Calibration_Michel(InputsModel = InputsModel, RunOptions = RunOptions, 
                                   InputsCrit = InputsCritCompo, CalibOptions = CalibOptions, 
                                   FUN_MOD = RunModel_GR4J)
end_time <- Sys.time()
end_time - start_time

## simulation
Param <- OutputsCalib$ParamFinalR
OutputsModel <- RunModel_GR4J(InputsModel = InputsModel,
                              RunOptions = RunOptions, Param = Param)

## Computation of the value of the performance criteria
## single efficiency criterion: KGE
InputsCrit <- CreateInputsCrit(FUN_CRIT = ErrorCrit_KGE,
                               InputsModel = InputsModel, RunOptions = RunOptions,
                               Obs = list(BasinObs$Qmm[Ind_Run]),
                               VarObs = "Q", transfo = "",
                               Weights = NULL)
## single efficiency criterion: KGE sqrt
InputsCrit2 <- CreateInputsCrit(FUN_CRIT = ErrorCrit_KGE,
                                InputsModel = InputsModel, RunOptions = RunOptions,
                                Obs = list(BasinObs$Qmm[Ind_Run]),
                                VarObs = "Q", transfo = "sqrt",
                                Weights = NULL)
OutputsCrit <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit,
                                    OutputsModel = OutputsModel,
                                    verbose = FALSE)## Computation of the value of the performance criteria
OutputsCrit2 <- airGR::ErrorCrit_KGE(InputsCrit = InputsCrit2,
                                     OutputsModel = OutputsModel,
                                     verbose = FALSE)
print(c(OutputsCrit$CritValue, OutputsCrit2$CritValue))

