#!/usr/bin/python 
#  Description: THE MARCS MAIN VISUALISATION MODULE v0.1
#  Experiment: Pan-Arctic
#  05.03.2018
#  Current Code Owner: Elena Shevnina, Finnish Meteorological Institute
#  ph. +358449185446
#  e-mail:eshevnina@gmail.com


# coding: utf-8
import sys
import numpy as np
import pandas as pd

# WORKING DIRECTORY
WD = './'

#Basic statistic for the reference period: group by country
# Load data from csv file
#X,Y,grdc_no,river,station,ccode,lat,long,area,altitude,m1,m2,pre,InRunCoef,m3
data = pd.DataFrame.from_csv('MARCS_setup.csv', sep=',')

#calculation CV and CS/CV
data['cv'] = np.sqrt(data.m2 - data.m1 ** 2) / data.m1
data['cs'] = (data.m3 - 3 * data.m2 * data.m1 + 2 * data.m1 ** 3) / (data.cv ** 3 * data.m1 ** 3)
data['cs/cv'] = data.cs / data.cv
#statistics by country
groups = data.groupby(['station']).groups.keys()
#Table2 (Shevnina et al., 2018)
table2 = pd.DataFrame(index = groups)
table2['count'] = data.groupby('station')['m1'].count()
table2['Mean_IRC'] = data.groupby('station')['InRunCoef'].mean()
table2['m1_q10'] = data.groupby('station')['m1'].quantile(0.1)
table2['m1_q90'] = data.groupby('station')['m1'].quantile(0.9)
table2['Mean_cv'] = data.groupby('station')['cv'].mean()
#table2['Min_cv'] = data.groupby('station')['cv'].min()
#table2['Max_cv'] = data.groupby('station')['cv'].max()
table2['cs/cv'] = data.groupby('station')['cs/cv'].mean()
table2['Mean_pre'] = data.groupby('station')['pre'].mean()
table2['pre_q10'] = data.groupby('station')['pre'].quantile(0.1)
table2['pre_q90'] = data.groupby('station')['pre'].quantile(0.9)
table2.to_csv('reference_by_country.csv')

#Basic statistic for the projected period, annual precipitation amount: group by country
# Load data from csv file
#X,Y,grdc_no,country_co,lat,long,area,altitude,fGRDC_NO,fCOUNTRY_C,fLAT_ORG,fLONG_ORG,fAREA,fca26_p_f,fca45_p_f,fca85_p_f,fhad26_p_f,fhad45_p_f,fhad85_p_f,finm45_p_f,finm85_p_f,fmpi85_p_f,fmpi45_p_f,fmpi26_p_f
ccp = pd.DataFrame.from_csv('MARCS_forsing.csv', sep=',')
keys = ccp.groupby(['fCOUNTRY_C']).groups.keys()
#statistics by country: Table3 (Shevnina et al., 2018)
table3 = pd.DataFrame(index = keys)
table3['CA26'] = ccp.groupby('fCOUNTRY_C')['fca26_p_f'].mean()
table3['CA45'] = ccp.groupby('fCOUNTRY_C')['fca45_p_f'].mean()
table3['CA85'] = ccp.groupby('fCOUNTRY_C')['fca85_p_f'].mean()
table3['HAD26'] = ccp.groupby('fCOUNTRY_C')['fhad26_p_f'].mean()
table3['HAD45'] = ccp.groupby('fCOUNTRY_C')['fhad45_p_f'].mean()
table3['HAD85'] = ccp.groupby('fCOUNTRY_C')['fhad85_p_f'].mean()
table3['MPI26'] = ccp.groupby('fCOUNTRY_C')['fmpi26_p_f'].mean()
table3['MPI45'] = ccp.groupby('fCOUNTRY_C')['fmpi45_p_f'].mean()
table3['MPI85'] = ccp.groupby('fCOUNTRY_C')['fmpi85_p_f'].mean()
table3['INM45'] = ccp.groupby('fCOUNTRY_C')['finm45_p_f'].mean()
table3['INM85'] = ccp.groupby('fCOUNTRY_C')['finm85_p_f'].mean()
table3.to_csv('forcing_by_country.csv')

#Basic statistic for the projected period, annual precipitation amount: group by country
# Load data from csv file Model_results.csv
#X,Y,grdc_no,country_co,lat,long,area,altitude,
#model_cons,model_co_1,model_co_2,InRunCoef,
#dM1_mpi85,dM1_had85,dM1_cad85,CVref,dM1_mpi26,dM1_had26,dM1_cad26,
#had26field_16,had26field_19,had26field_25(CV),had26field_26(CV2050),had26field_27(CS),
#had45field_16,had45field_19,had45field_26,
#had85field_16,had85field_19,had85field_26,
#ca26field_16,ca26field_19,ca26field_26,
#ca45field_16,ca45field_19,ca45field_26,
#ca85field_16,ca85field_19,ca85field_26,
#mpi26field_16,mpi26field_19,mpi26field_26,
#mpi45field_16,mpi45field_19,mpi45field_26,
#mpi85field_16,mpi85field_19,mpi85field_26,
#inm45field_16,inm45field_19,inm45field_26,
#inm85field_16,inm85field_19,inm85field_26


arr2050 = pd.DataFrame.from_csv('MARCS_results.csv', sep=',')
keys = arr2050.groupby(['country_co']).groups.keys()
#statistics by country: Table4 (Shevnina et al., 2018)
table4 = pd.DataFrame(index = keys)
table4['M1'] = arr2050.groupby('country_co')['model_cons'].mean()
table4['M12050_CA26'] = arr2050.groupby('country_co')['ca26field_19'].mean()
table4['M12050_CA45'] = arr2050.groupby('country_co')['ca45field_19'].mean()
table4['M12050_CA85'] = arr2050.groupby('country_co')['ca85field_19'].mean()
table4['M12050_HAD26'] = arr2050.groupby('country_co')['had26field_19'].mean()
table4['M12050_HAD45'] = arr2050.groupby('country_co')['had45field_19'].mean()
table4['M12050_HAD85'] = arr2050.groupby('country_co')['had85field_19'].mean()
table4['M12050_MPI26'] = arr2050.groupby('country_co')['mpi26field_19'].mean()
table4['M12050_MPI45'] = arr2050.groupby('country_co')['mpi45field_19'].mean()
table4['M12050_MPI85'] = arr2050.groupby('country_co')['mpi85field_19'].mean()
table4['M12050_INM45'] = arr2050.groupby('country_co')['inm45field_19'].mean()
table4['M12050_INM85'] = arr2050.groupby('country_co')['inm85field_19'].mean()
table4.to_csv('M12050_by_country.csv')

#the reference and projected CV values
#statistics by country: Table5 (Shevnina et al., 2018)
table5 = pd.DataFrame(index = keys)
table5['CV'] = arr2050.groupby('country_co')['had26field_25'].mean()
table5['CV2050_CA26'] = arr2050.groupby('country_co')['ca26field_26'].mean()
table5['CV2050_CA45'] = arr2050.groupby('country_co')['ca45field_26'].mean()
table5['CV2050_CA85'] = arr2050.groupby('country_co')['ca85field_26'].mean()
table5['CV2050_HAD26'] = arr2050.groupby('country_co')['had26field_26'].mean()
table5['CV2050_HAD45'] = arr2050.groupby('country_co')['had45field_26'].mean()
table5['CV2050_HAD85'] = arr2050.groupby('country_co')['had85field_26'].mean()
table5['CV2050_MPI26'] = arr2050.groupby('country_co')['mpi26field_26'].mean()
table5['CV2050_MPI45'] = arr2050.groupby('country_co')['mpi45field_26'].mean()
table5['CV2050_MPI85'] = arr2050.groupby('country_co')['mpi85field_26'].mean()
table5['CV2050_INM45'] = arr2050.groupby('country_co')['inm45field_26'].mean()
table5['CV2050_INM85'] = arr2050.groupby('country_co')['inm85field_26'].mean()
table5.to_csv('CV2050_by_country.csv')

#the projected ARR10 and ARR90 
#statistics by country: Table6 (Shevnina et al., 2018)

table6 = pd.DataFrame(index = keys)




