\name{setVariables}
\alias{setVariables}

\title{
  Set variables for model building
}

\description{
  Prepares a list with all necessary information about the variables intended
  to build the model. Only series on a daily basis are supported.
}

\usage{
setVariables(v = NULL)
}

\arguments{
  \item{v}{list; see 'Details'}
}

\details{
  Each list in \code{v} (that is either a predictand or a predictor) must
  contain the following named objects: 
  \describe{
    \item{\code{type}}{character, either "x" (predictor) or "y" (predictand)}
    \item{\code{file}}{string, the file name. See below for file
      specifications.}
    \item{\code{col}}{string, name of column in \code{file} to extract}
    \item{\code{fun}}{string, function name to use for the aggregation}
    \item{\code{args}}{list, additional arguments passed to
      \code{fun}. The list entries need to be named, e.g. if
      \code{fun="quantile"} one might use
      \code{args=list(probs=0.9,na.rm=TRUE)}. This list entry is
      optional.}
    \item{\code{agg}}{signed integer(s), the time aggregation in number of
      days. Negative values denote the number of consecutive days before the
      date of prediction (termed \code{t1}, i.e. the first day of the
      forecast window), and positive values denote the number of consecutive
      days starting at \code{t1}. Hence, for negative values \code{t1} is
      not included, whereas for positive values \code{t1} is included}
  }
}

\value{
  list
}

\note{
  This function is necessary in order to apply
  \code{\link{getSeries}} and \code{\link{applyBag}}. It may also be
  helpful to predict with fitted models when the corresponding file
  structure has changed in the meanwhile.

  It will be an error to define more than one entry in \code{v} of type
  "y". Additionally, a predictand can have just one aggregation period
  \code{agg}. Please note that each entry of type "x" in \code{v} defines
  a separate pool of candidate predictors.

  Both the predictand and the predictors must be numeric,
  i.e. categorical variables do not get converted.
  
  \code{file} must either be readable according:\cr
  \code{df <- read.table(file,sep=';',header=T,stringsAsFactors=F)}\cr
  \code{df$date <- as.Date(df$date)}\cr
  or must be an rds file, which contains a numeric matrix with dates
  as row names (again readable as \code{as.Date(rownames(x))}).
}
