\name{series}
\alias{series}
\docType{data}

\title{
  Daily time series for a use case
}
\description{
  The series contains observations of streamflow, precipitation, and
  surface air temperature of an anonymous catchment.
}

\usage{data("series")}

\format{
  The column names refer to streamflow ("Q"), precipitation ("P"), and
  surface air temperature ("T") and the row names contain the dates
  according to the pattern "YYYY-MM-DD".
}

\examples{
## use case from the package vignette
\dontrun{
data('series',package='SRWHessS2S')
summary(series)
saveRDS(series,'/somewhere/on/the/disk/series.rds')

f <- '/somewhere/on/the/disk/series.rds'
yag <- 30
xagb <- -1*seq(10,720,by=10)
xagf <- seq(10,yag,by=10)
l <- list(list(type='y',file=f,col='Q',fun='mean',agg=yag),
          list(type='x',file=f,col='P',fun='sum',agg=xagb),
          list(type='x',file=f,col='P',fun='sum',agg=xagf),
          list(type='x',file=f,col='T',fun='mean',agg=xagb),
          list(type='x',file=f,col='T',fun='mean',agg=xagf))
v <- setVariables(v=l)

p <- c(1981:2010)
d <- getSeries(v=v,p=p)
head(d)

set.seed(1)
B <- 100
t1 <- '06-01'
mo <- buildBag(v=v,p=p[1:20],d=d,t1=t1,na.rm=F,B=B,shuffle=F)
str(mo)

par(mfrow=c(1,2))
boxplot(mo$mo[,grepl('^b\\.x',dimnames(mo$mo)[[2]])],main='regression coefficients')
boxplot(mo$mo[,grepl('^ag\\.x',dimnames(mo$mo)[[2]])],main='aggregation periods',ylab='days')

sk <- getSkill(va=mo$va)
sk$si
par(mfrow=c(1,2))
plot(x=sk$ts[,'p'],y=sk$ts[,'o'],xlab='prediction',ylab='observation')
abline(a=0,b=1,lty=3)
plot(sk$es,xlab='number of replicates',ylab='MSEP')

op <- applyBag(v=v,p=p[21:30],d=d,mo=mo$mo,sc=mo$sc,t1=t1,na.rm=F)
par(mfrow=c(1,1))
plot(x=op[,c('p','o')],xlab='prediction',ylab='observation')
abline(a=0,b=1,lty=3)
}
}

