\name{runHindcast}
\alias{runHindcast}

\title{
  Run a hindcast
}

\description{
  Wrapper function for a specific hindcast experiment and thus rather
  useless.
}

\usage{
runHindcast(lv, p, t1s, win, shu, B, ecmf)
}

\arguments{
  \item{lv}{list passed to \code{\link{setVariables}}}
  \item{p}{integer vector, years for the hindcast experiment}
  \item{t1s}{character vector, dates of prediction within the calendar
    year according to the pattern "MM-DD"}
  \item{win}{integer, number of years to buffer the leave-one-out validation}
  \item{shu}{boolean, apply shuffling? Passed to
    \code{\link{buildBag}}.}
  \item{B}{integer, number of bootstrap replicates}
  \item{ecmf}{boolean, does the regression model contain seasonal
    climate predictions from ECMWF? If so, the seasonal climate
    predictions closest to the date of prediction are selected by
    adapting the variable names.}
}

\value{
  list of arrays
}

\examples{
## The function is currently defined as
function(lv,p,t1s,win,shu,B,ecmf) {

    np <- length(t1s)
    ny <- length(p)
    cvs <- matrix(rep(1:ny,times=3)[rep((ny-win+1):(ny+win+1),times=ny)+rep(0:(ny-1),each=2*win+1)],
                  nrow=ny,ncol=2*win+1,byrow=T)

    di <- paste(rep(p,each=np),rep(t1s,times=ny),sep='-')
    mi <- formatC(1:12,width=2,flag='0')
    names(mi) <- t1s

    v <- setVariables(v=lv)
    if(!ecmf) {d <- getSeries(v=v,p=p)}

    nx <- sum(v$vars$isx)
    mo <- array(NA,dim=c(B,2*nx+2,np),dimnames=list(NULL,NULL,t1s))
    sc <- array(NA,dim=c(B,nx+1,2,np),dimnames=list(NULL,NULL,NULL,t1s))
    va <- array(NA,dim=c(B,ny,3,np),dimnames=list(NULL,NULL,NULL,t1s))
    ts <- array(NA,dim=c(ny*np,1),dimnames=list(di,NULL))

    for(j in t1s) {

        if(ecmf) {
            v$vars$name <- sub('ecmf[[:digit:]]*',paste0('ecmf',mi[j]),v$vars$name)
            v$cols <- lapply(v$cols,function(x){sub('ecmf[[:digit:]]*',paste0('ecmf',mi[j]),x)})
            d <- getSeries(v=v,p=p)
        }

        for(k in 1:nrow(cvs)) {
            mf <- buildBag(v=v,p=p[-cvs[k,]],d=d,t1=j,na.rm=F,B=B,shuffle=shu)
            op <- applyBag(v=v,p=p[k],d=d,mo=mf$mo,sc=mf$sc,t1=j,na.rm=F)
            ts[paste(p[k],j,sep='-'),] <- op[1,'p'] 
        }

        mf <- buildBag(v=v,p=p,d=d,t1=j,na.rm=F,B=B,shuffle=shu)
        mo[,,as.character(j)] <- mf$mo
        sc[,,,as.character(j)] <- mf$sc
        va[,,,as.character(j)] <- mf$va
        
    }

    dimnames(mo)[1:2] <- dimnames(mf$mo)
    dimnames(sc)[1:3] <- dimnames(mf$sc)
    dimnames(va)[1:3] <- dimnames(mf$va)

    if(ecmf) {
        dimnames(mo)[[2]] <- sub('ecmf[[:digit:]]*','ecmf',dimnames(mo)[[2]])
        dimnames(sc)[[2]] <- sub('ecmf[[:digit:]]*','ecmf',dimnames(sc)[[2]])
    }

    return(list(mo=mo,sc=sc,va=va,ts=ts))
    
}
}
