\name{getVariables}
\alias{getVariables}
\alias{getPredictand}
\alias{getPredictors}

\title{
  Get aggregated variables
}

\description{
  Returns an array consisting of variables aggregated in time.
}

\usage{
getPredictand(v = NULL, p = NULL, d = NULL, t1 = NULL, na.rm = NULL)
getPredictors(v = NULL, p = NULL, d = NULL, t1 = NULL, na.rm = NULL)
}

\arguments{
  \item{v}{list as returned by \code{\link{setVariables}}}
  \item{p}{integer vector containing years for which to aggregate the
    predictors with respect to \code{t1}}
  \item{d}{numeric matrix as returned by \code{\link{getSeries}}}
  \item{t1}{string, date of prediction within the calendar year
  according to the pattern "MM-DD". \code{t1} is the first day of the
  forecast window.}
  \item{na.rm}{boolean, remove missing values whilst aggregating the
    predictand? If supplied, overrides any \code{na.rm} arguments in \code{v}.}
}

\details{
   These functions are called by \code{\link{buildBag}} and
   \code{\link{applyBag}}.
}

\value{
  Array which contains the dates of prediction \code{t1} in the
  \code{\link{dimnames}}. 
}