\name{getSkill}
\alias{getSkill}

\title{
  Estimate model skill
}

\description{
  Returns observations and corresponding predictions as well as an MSEP
  estimate and some skill indices.
}

\usage{
getSkill(va = NULL)
}

\arguments{
  \item{va}{array, as returned by \code{\link{buildBag}}}
}

\details{
  Only predictions for which the corresponding observation was not part of
  the model training are considered (i.e. entries in \code{va} for which
  the "test" field is set to \code{TRUE}). Quantities estimated in such a way
  are called out-of-bag estimates in the context of bagging and can be
  considered as an approximation to the leave-one-out validation.
}

\value{
  List containing:
  \item{ts}{matrix with columns "o" (observations) and "p" (predictions)}
  \item{si}{matrix with columns "MSEP" (mean squared error of
  prediction), "NSE" (Nash Sutcliffe Efficiency), and "r" (Pearsons
  correlation)}
  \item{es}{numeric vector. Contains the mean squared error when the
    number of bootstrap replicates gets increased (error screening).
    Can be used to estimate how many bootstrap replicates are necessary
    for the bagging procedure.}
}

