\name{getSeries}
\alias{getSeries}

\title{
  Gather time series from file sources
}

\description{
  Returns time series, as specified in \code{v}, as a matrix. Out of this
  matrix the predictand and the predictors will be derived through temporal
  aggregation.
}

\usage{
getSeries(v = NULL, p = NULL)
}

\arguments{
  \item{v}{list as returned by \code{\link{setVariables}}}
  \item{p}{integer vector containing years. \code{min(p)} and
    \code{max(p)} are used to construct a regular series on a daily basis.}
}

\details{
  The row names contain the daily dates.
}

\value{
  matrix
}

\note{
  Series are returned with respect to \code{p} as well as the aggregation
  periods of the variables specified in \code{v} (i.e. \code{p} gets
  extended by \code{agg}). The column names within the returned matrix
  are composed of \code{type}, \code{col}, and an index in order to
  provide unique names. Daily regularity is guaranteed.
}