\name{applyBag}
\alias{applyBag}

\title{
  Predict with a bagged model
}

\description{
  Predict given year(s) using a bagged model.
}

\usage{
applyBag(v = NULL, p = NULL, d = NULL, mo = NULL,
         sc = NULL, t1 = NULL, na.rm = NULL)
}

\arguments{
  \item{v}{list as returned by \code{\link{setVariables}}}
  \item{p}{integer vector containing the years to predict}
  \item{d}{numeric matrix as returned by \code{\link{getSeries}}}
  \item{mo}{array \code{mo} as returned by \code{\link{buildBag}}}
  \item{sc}{array \code{sc} as returned by \code{\link{buildBag}}}
  \item{t1}{string, date of prediction within the calendar year
    according to the pattern "MM-DD". \code{t1} is the first day of the
    forecast window.}
  \item{na.rm}{boolean, remove missing values whilst aggregating the
    variables and estimating moments for variable scaling? Passed to
    \code{\link{getPredictand}} and \code{\link{getPredictors}} and thus
    overrides any \code{na.rm} arguments in \code{v$args}.}
}

\value{
  matrix with columns "o" (observations), and "p" (predictions)
}

\note{
  Years in \code{p} which are not contained in \code{d} will be omitted.
}
