setVariables <- function(v=NULL) {
    
    isy <- unlist(lapply(v,function(x){x$type=='y'}),use.names=F)
    if(sum(isy)!=1) {stop('only one predictand allowd')}
    if(length(v[[which(isy)]]$col)!=1) {stop('only one predictand allowd')}
    if(length(v[[which(isy)]]$agg)!=1) {stop('only one aggregation period for the predictand allowd')}

    isx <- unlist(lapply(v,function(x){rep(x$type=='x',times=length(x$col))}),use.names=F)
    lpos <- cumsum(unlist(lapply(v,function(x){i<-rep(0,times=length(x$col));i[1]<-1;i})))
    nms <- unlist(lapply(v,function(x){paste(x$type,x$col,sep='.')}))
    na <- unlist(lapply(v,function(x){length(x$agg)}))
    ma <- max(na)
    agg <- matrix(unlist(lapply(v,function(x){c(x$agg,rep(NA,times=ma))[1:ma]})),nrow=ma,ncol=length(isy))
    
    list(nov=length(isx),
         vars=data.frame(lpos=lpos,isx=isx,name=paste(nms,lpos,sep='.'),
                         nagg=na[lpos],stringsAsFactors=F),
         files=unlist(lapply(v,'[','file'),use.names=F),
         cols=lapply(v,'[[','col'),
         agg=agg,
         fun=lapply(v,'[[','fun'),
         args=lapply(v,'[[','args'))
    
}
