getPredictand <- function(v=NULL,p=NULL,d=NULL,t1=NULL,na.rm=NULL) {
    
    x <- as.Date(rownames(d))
    r <- range(x)
    dt1 <- x[format(x,'%m-%d')==t1]
    dt1 <- dt1[as.integer(format(dt1,'%Y'))%in%p]
    iy <- v$vars$lpos[!v$vars$isx]
    m <- matrix(NA,ncol=1,nrow=length(dt1),dimnames=list(format(dt1,'%Y-%m-%d'),v$vars$name[iy]))
    it1 <- match(dt1,x)
    a <- na.omit(v$agg[,iy])
    sg <- ifelse(a<0,-1,-(a+1))
    ii <- rep(it1,each=abs(a))+rep((0:a)[sg],times=length(dt1))
    gg <- rep(it1,each=abs(a))
    fa <- v$args[[iy]]
    if(!is.null(na.rm)) {fa[['na.rm']] <- na.rm}
    m[,v$vars$name[iy]] <- tapply(d[ii,iy],gg,function(x){do.call(v$fun[[iy]],args=c(list(x=x),fa))})
    return(m)
    
}

getPredictors <- function(v=NULL,p=NULL,d=NULL,t1=NULL,na.rm=NULL) {
    
    x <- as.Date(rownames(d))
    dt1 <- x[format(x,'%m-%d')==t1]
    dt1 <- dt1[as.integer(format(dt1,'%Y'))%in%p]
    it1 <- match(dt1,x)
    vv <- v$vars
    ix <- which(vv$isx)
    a <- v$agg
    m <- array(NA,dim=c(length(it1),length(ix),nrow(a)),dimnames=list(format(dt1,'%Y-%m-%d'),vv$name[ix],NULL))
    for (i in ix) {
        fa <- v$args[[vv$lpos[i]]]
        if(!is.null(na.rm)) {fa[['na.rm']] <- na.rm}
        ag <- na.omit(a[,vv$lpos[i]])
        for (j in 1:length(ag)) {
            aj <- ag[j]
            sg <- ifelse(aj<0,-1,-(aj+1))
            ii <- rep(it1,each=abs(aj))+rep((0:aj)[sg],times=length(dt1))
            gg <- rep(it1,each=abs(aj))
            m[,vv$name[i],j] <- tapply(d[ii,vv$name[i]],gg,function(x){do.call(v$fun[[vv$lpos[i]]],args=c(list(x=x),fa))})
        }
    }
    return(m)
    
}


