getSeries <- function(v=NULL,p=NULL) {
    
    f <- v$files
    ra <- range(v$agg,na.rm=T)
    ra <- c(ifelse(ra[1]<0,ra[1],0),ifelse(ra[2]<0,0,ra[2]))
    r <- as.Date(c(paste(min(p),'01-01',sep='-'),paste(max(p),'12-31',sep='-')))+ra
    d <- seq.Date(r[1],r[2],by='day')
    m <- matrix(NA,nrow=length(d),ncol=v$nov,dimnames=list(as.character(d),v$vars$name))
    fi <- ''
    
    for (i in order(match(f,unique(f)))) {
        
        if (fi!=f[i]) {
            fi <- f[i]
            if(grepl('\\.csv$',fi)) {
                h <- unlist(strsplit(readLines(fi,n=1),split=';'))
                l <- scan(file=fi,what=character(),sep=';',quote='',skip=1,quiet=T)
                nr <- length(l)/length(h)
                nc <- length(h)
                dim(l) <- c(nc,nr)
                mm <- matrix(as.numeric(t(l[-1,])),nrow=nr,ncol=nc-1,dimnames=list(l[1,],h[-1]))
            } 
            if(grepl('\\.rds$',fi)) {
                mm <- readRDS(fi)
            }
            ii <- as.character(d)%in%rownames(mm)
        }
        
        m[ii,v$vars$name[v$vars$lpos==i]] <- mm[as.character(d[ii]),v$cols[[i]]]
        
    }

    return(m)
    
}
