buildBag <- function(v=NULL,p=NULL,d=NULL,t1=NULL,na.rm=NULL,B=NULL,shuffle=NULL) {

    vv <- v$vars
    ix <- vv$isx
    xn <- vv$name[ix]
    yn <- vv$name[!ix]
    
    y <- getPredictand(v=v,p=p,d=d,t1=t1,na.rm=na.rm)
    x <- getPredictors(v=v,p=p,d=d,t1=t1,na.rm=na.rm)

    nn <- nrow(y)
    np <- length(xn)

    mo <- array(NA,dim=c(B,2*np+1),dimnames=list(NULL,c('b0',paste('b',xn,sep='.'),paste('ag',xn,sep='.'))))
    sc <- array(NA,dim=c(B,np+1,2),dimnames=list(NULL,c(yn,xn),c('mn','sd')))
    va <- array(NA,dim=c(B,nn,3),dimnames=list(NULL,p,c('test','o','p')))
    
    xx <- matrix(NA,nrow=nn,ncol=np+1,dimnames=list(NULL,c('b0',xn)))
    xx[,'b0'] <- 1
    va[,,'o'] <- rep(y[,yn],each=B)
    yy <-  numeric(nn)
    tri <- integer(nn)
    tr <- logical(nn)
    co <- matrix(NA,nrow=np,ncol=dim(x)[3],dimnames=list(xn,NULL))
    ai <- integer(np)
    names(ai) <- xn

    s <- 1:nn
    if (shuffle) {s <- sample.int(n=nn)}
    
    for (i in 1:B) {
        
        tri[] <- sample.int(nn,replace=T)
        tr[] <- rep(F,nn)
        tr[tri] <- T
        
        co[] <- apply(x[tri,,,drop=F],2:3,cor,y=y[s[tri],yn],method='pearson',use='na.or.complete')
        ai[] <- apply(abs(co),1,which.max)
        for (j in xn) {xx[,j] <- x[,j,ai[j]]}
        
        mo[i,paste('ag',xn,sep='.')] <- v$agg[matrix(c(ai,vv$lpos[ix]),ncol=2)]
        sc[i,c(yn,xn),'mn'] <- c(mean(y[s[tri]],na.rm=na.rm),apply(xx[tri,xn,drop=F],2,mean,na.rm=na.rm))
        sc[i,c(yn,xn),'sd'] <- c(sd(y[s[tri]],na.rm=na.rm),apply(xx[tri,xn,drop=F],2,sd,na.rm=na.rm))
        
        yy[] <- (y[s,yn]-sc[i,yn,'mn'])/sc[i,yn,'sd']
        xx[,xn] <- scale(xx[,xn],center=F,scale=sc[i,xn,'sd'])
        
        m <- .lm.fit(x=xx[tri,],y=yy[tri])
        if(m$rank<(np+1)) {warning('cov is singular',immediate.=T)}
        
        mo[i,c('b0',paste('b',xn,sep='.'))] <- m$coefficients
        va[i,,'test'] <- !tr
        va[i,,'p'] <- xx%*%mo[i,c('b0',paste('b',xn,sep='.'))]*sc[i,yn,'sd']+sc[i,yn,'mn']
        xx[,xn] <- NA
        
    }
    
    list(mo=mo,sc=sc,va=va)
    
}
