
casenames <- c('I: all original',
               'II: original loading',
               'III: original weather',
               'IV: original weather (wind speed only)',
               'V original weather (air temperature only)',
               'VI: original weather (irradiance only)',
               'VII: original weather (precipitation only)',
               'VIII: all repeated avarage year')

ms <- read.csv('meantableOct.csv', row.names=1)
names(ms) <- c('cases', 'years', 'TP', 'Chl',
               'Therm', 'Epi', 'Light', 'Ice')
d2015 <- ms
d2015 <- subset(d2015, cases %in% c('case01', 'case02',
                                    'case03', 'case08'))
d2015[['W']] <- ifelse(d2015[['cases']] %in% c('case01', 'case03'),
                       'original', 'repeated')
d2015[['L']] <- ifelse(d2015[['cases']] %in% c('case01', 'case02'),
                       'original', 'repeated')
vnamesshort <- names(d2015)[3:8]
formulae <- lapply(as.list(vnamesshort),
                   function(x) {
                     as.formula(sprintf('%s ~ W * L + Error(years)', x))
                   })
formulae0 <- lapply(as.list(vnamesshort),
                   function(x) {
                     as.formula(sprintf('%s ~ W * L', x))
                   })
vii <- as.list(1:6)
mlist <- lapply(vii, function(i) aov(formulae[[i]], data=d2015))
names(mlist) <- vnamesshort
mlist0 <- lapply(vii, function(i) aov(formulae0[[i]], data=d2015))
names(mlist0) <- vnamesshort

## example
print(mlist[['Ice']])
print(summary(mlist[['Ice']]))

results <- data.frame(matrix(NA, nrow=6, ncol=13), row.names=names(ms)[3:8])
names(results) <- c(paste0('SS_', c('W', 'L', 'W:L', 'Residuals')),
                    paste0('SS(Frac)_', c('W', 'L', 'W:L')),
                    paste0('F_', c('W', 'L', 'W:L')),
                    paste0('P_', c('W', 'L', 'W:L')))
for (vi in 1:6) {
  s <- summary(mlist[[vi]])
  sew <- s[['Error: Within']][[1]]
  results[vi, 1:4] <- sew[['Sum Sq']]
  results[vi, 5:7] <- sew[['Sum Sq']][1:3] / sum(sew[['Sum Sq']])
  results[vi, 8:10] <- sew[['F value']][1:3]
  results[vi, 11:13] <- sew[['Pr(>F)']][1:3]
}
write.csv(results, file='summarystats.csv')

