function IsoQ = importIsoQ(filename, dataLines)
%IMPORTFILE Import data from a text file
%  ID = IMPORTFILE(FILENAME) reads data from text file FILENAME for the
%  default selection.  Returns the data as a table.
%
%  ID = IMPORTFILE(FILE, DATALINES) reads data for the specified row
%  interval(s) of text file FILENAME. Specify DATALINES as a positive
%  scalar integer or a N-by-2 array of positive scalar integers for
%  dis-contiguous row intervals.
%
%  Example:
%  ERL = importfile("C:\Users\...\Anonymous_referee1\isotopes_streamflow\ERL.isoStrm", [24, Inf]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 16-Mar-2023 17:36:23

%% Input handling

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [24, Inf];
end

%% Setup the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 11);

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = "\t";

% Specify column names and types
opts.VariableNames = ["date", "Analysis_date", "d18O_mean", "d2H_mean", "D_excess", "SamplQ_idx", "Q_percentile", "DoubleMeasurement", "Outlier_2H", "Outlier_18O", "Comment"];
opts.VariableTypes = ["datetime", "datetime", "double", "double", "double", "double", "double", "categorical", "double", "double", "categorical"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Specify variable properties
opts = setvaropts(opts, ["DoubleMeasurement", "Comment"], "EmptyFieldRule", "auto");
opts = setvaropts(opts, "date", "InputFormat", "yyyy-MM-dd");
opts = setvaropts(opts, "Analysis_date", "InputFormat", "yyyy-MM-dd");

% Import the data
IsoQ = readtable(filename, opts);

end