function isoPrec = importIso(filename, dataLines)
%IMPORTFILE Import data from a text file
%  ID = IMPORTFILE(FILENAME) reads data from text file FILENAME for the
%  default selection.  Returns the data as a table.
%
%  ID = IMPORTFILE(FILE, DATALINES) reads data for the specified row
%  interval(s) of text file FILENAME. Specify DATALINES as a positive
%  scalar integer or a N-by-2 array of positive scalar integers for
%  dis-contiguous row intervals.
%
%  Example:
%  ERL = importfile("C:\Users\...\Anonymous_referee1\Precipitation\ERL.isoPrcp", [14, Inf]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 14-Mar-2023 22:04:12

%% Input handling

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [14, Inf];
end

%% Setup the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 5);

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = "\t";

% Specify column names and types
opts.VariableNames = ["date", "d18O_prcp", "d18O_source", "dDeuterium_prcp", "dDeuterium_source"];
opts.VariableTypes = ["datetime", "double", "double", "double", "double"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Specify variable properties
opts = setvaropts(opts, "date", "InputFormat", "yyyy-MM-dd");
opts = setvaropts(opts, ["d18O_source", "dDeuterium_source"], "TrimNonNumeric", true);
opts = setvaropts(opts, ["d18O_source", "dDeuterium_source"], "ThousandsSeparator", ",");

% Import the data
isoPrec = readtable(filename, opts);

end