%% Event derivation tool 
% Contact:
% Sergiy Vorogushyn and Bjrn Guse
% sergiy.vorogushyn@gfz-potsdam.de and bjrn.guse@gfz-potsdam.de
% GFZ German Research Centre for Geosciences, Hydrology Section, Telegrafenberg, Potsdam, Germany
% 26.01.2016 to 31.01.2020

% The program identifies AMS peak flows from the daily series, 
% separates flow hydrographs based on the gradient method after B. Klein(2009)
% and detects baseflow discharge for AMS flood events.

%% load data
clear all
close all

% example for datapath, please adjust
datapath = 'F:\bfguse\Daten_Auswertung\Flood wave superposition\Tripelpunkte\triplepoint_files\';

% File format 
dataext = 'xlsx';

%name of gauging-data files
triplefiles = dir([datapath '*.*'  dataext]);

%number of files
n_triplefiles = length(triplefiles);

% Example for the first site
site_start = 1;
site_end = site_start;

for isite=site_start:site_end
    
    Qbase_date=[];
    Qpeakdate_num =[];
    Qduration=[];
    Qpeakvalue =[];
    Qpeakdate=[];
    Qstartdate=[];
    Qenddate=[];
    Qstart=[];
    Qend=[];
    Centroid_X=[];
    Centroid_Y=[];
    Centroid_Ytotal=[];
    Qstartdate2=[];
    Qenddate2=[];
    
[num, txt] = xlsread([datapath triplefiles(isite).name]);

% Read the daily streamflow data from the selected gauges. 
% Data were already pre-procesed and gaps filled.

ymin = min(num(:,1));
ymax = max(num(:,1));

% day
d = num(:,3);
% month
m = num(:,2);
% year
y = num(:,1);
% each column represents one station from column 4 to 6
% column 4: upstream gauge in the main river
% column 5: tributary gauge
% column 6: downstream gauge in the main river
q = num(:,4:6);

%% get maximum annual discharge, the annual series and the flood events per year from data series
% events are defined as those around the annual peak above the mean annual
% discharge

%figure;
x = ymin+1:ymax;

   Qams = zeros(length(x),size(q,2));
   Qamsdate = Qams;

   
%loop over downstream gauge
for k = 3:3

Q = [d m y q(:,k)];
Qorig = Q;

Q(any(isnan(Q),2),:) = [];

% calculation of flood characteristics for all AMS
[Qa, Qa_series, QbaseS, QbaseE, Qpeak, Qdur, QindSdate, QindEdate, x_centroid, y_centroid, ytotal_centroid, QindSdate2, QindEdate2, Qvol, eventmat_down] = Event_derivation_downstream_gauge(Q);

% event start for the three gauges as continuous number
Qbase_date(:,k) = datenum(QbaseS(:,3), QbaseS(:,2), QbaseS(:,1));
    
 % standardize the QbaseG with respect to the long-term mean monthly QbaseG
% discharge -> de-seasonalize baseflow
    for i = 1:length(QbaseS)

                % standardize to the the period +-15 days around the
                % baseflow time point
                
                [Y1,M1,D1] = datevec(Qbase_date(i,k) - 15);
                [Y2,M2,D2] = datevec(Qbase_date(i,k) + 15);
                
                % Check for leap years
                if (M1==2 && D1 == 29)
                    D1 = 28;
                elseif (M2==2 && D2 ==29)
                    D2 = 28;
                end
                
                iQ1 = find(Q(:,2)==M1 & Q(:,1)==D1);
                iQ2 = find(Q(:,2)==M2 & Q(:,1)==D2);
                
                % Consider the case when the indices of the 30-days window
                % (iQ1) or (iQ2) lie ahead or beyond the Q time series
                % window -> exclude the first and the last year from the
                % standardization period
                
                if (iQ1(1) > iQ2(1))
                    % the baseflow date-15 is earlier than 1.11.
                    % cut the first and the last year out
                        iQ1 = iQ1(1:end-1);
                        iQ2 = iQ2(2:end);
                elseif (length(iQ1) > length(iQ2))
                    % baseflow date+15 is later than 31.10.
                    % cut only the last year out 
                        iQ1 = iQ1(1:end-1);
                end
                
                Q_mean = mean(Q(iQ1:iQ2, 4));
                Q_std = std(Q(iQ1:iQ2, 4));  
                               
                 % standardize baseflow to the mean and std of the flow
                 % within the time period of +-15 days around the baseflow
                 % date
                 % QbaseG(i,k) = (Qbase(i,4) - Q_mean) ./ Q_std;          
                 
                QbaseG(i,k) = QbaseS(i,4);
    
                % AMS save
                Qams(i,k) = Qa(i,2);
                Qams_date(i,k) = Qa(i,1);
    end
    
    % Event duration
    Qduration(:,k) = Qdur(:,2);
    % Event peak value
    Qpeakvalue(:,k) = Qpeak(:,4);
    
    % Days of event peak at the three gauges
    k123 = (k-1)*3+1;
    Qpeakdate(:,k123:k123+2) = Qpeak(:,1:3);
    
    % Event start and end of these days of the year
    Qstartdate(:,k) = QindSdate(:,1);
    Qenddate(:,k) = QindEdate(:,1);
    
    % Event centroid: X value (time)
    Centroid_X(:,k) = x_centroid;
    % Event centroid: Y value (discharge without base flow)
    Centroid_Y(:,k) = y_centroid;
    % Event centroid: Y value (discharge with base flow)
    Centroid_Ytotal(:,k) = ytotal_centroid;
       
    % Event volume
    Qvolume(:,k) = Qvol;
    
end


QindSdate2_down = QindSdate2;
QindEdate2_down = QindEdate2;
%loop over upstream and tributary gauge
for k = 1:2

Q = [d m y q(:,k)];
Qorig = Q;

Q(any(isnan(Q),2),:) = [];

% extract baseflow time series based on the gradient method
% based on peak of downstream gauge
[Qa, Qa_series, QbaseS, QbaseE, Qpeak, Qdur, QindSdate, QindEdate, x_centroid, y_centroid, ytotal_centroid, QindSdate2, QindEdate2, Qvol, eventmat_site] = Event_derivation_upstream_tributary_gauges(Q, QindSdate2_down, QindEdate2_down);

if (k==1)
    eventmat_up = eventmat_site;
end
if (k==2)
    eventmat_trib = eventmat_site;
end
datesize = size(Qbase_date);
    Qbase_date(:,k) = datenum(QbaseS(1:datesize(1),3), QbaseS(1:datesize(1),2), QbaseS(1:datesize(1),1));
    
 
% standardize the QbaseG with respect to the long-term mean monthly QbaseG
% discharge -> de-seasonalize baseflow
    for i = 1:length(QbaseG)

                % standardize to the the period +-15 days around the
                % baseflow time point
                
                [Y1,M1,D1] = datevec(Qbase_date(i,k) - 15);
                [Y2,M2,D2] = datevec(Qbase_date(i,k) + 15);
                
                % Check for leap years
                if (M1==2 && D1 == 29)
                    D1 = 28;
                elseif (M2==2 && D2 ==29)
                    D2 = 28;
                end
                
                iQ1 = find(Q(:,2)==M1 & Q(:,1)==D1);
                iQ2 = find(Q(:,2)==M2 & Q(:,1)==D2);
                
                % Consider the case when the indices of the 30-days window
                % (iQ1) or (iQ2) lie ahead or beyond the Q time series
                % window -> exclude the first and the last year from the
                % standardization period
                
                if (iQ1(1) > iQ2(1))
                    % the baseflow date-15 is earlier than 1.11.
                    % cut the first and the last year out
                        iQ1 = iQ1(1:end-1);
                        iQ2 = iQ2(2:end);
                elseif (length(iQ1) > length(iQ2))
                    % baseflow date+15 is later than 31.10.
                    % cut only the last year out 
                        iQ1 = iQ1(1:end-1);
                end
                
                Q_mean = mean(Q(iQ1:iQ2, 4));
                Q_std = std(Q(iQ1:iQ2, 4));  
                               
                 % standardize baseflow to the mean and std of the flow
                 % within the time period of +-15 days around the baseflow
                 % date
                 % QbaseG(i,k) = (Qbase(i,4) - Q_mean) ./ Q_std;          
                 
                QbaseG(i,k) = QbaseS(i,4);    
               
              
                 % AMS save
                Qams(i,k) = Qa(i,2);
                Qams_date(i,k) = Qa(i,1);
    end

    % Results of the event of the current year are saved in different
    % matrices
    
    % Event duration
    Qduration(:,k) = Qdur(1:datesize(1),2);
    % Event peak value
    Qpeakvalue(:,k) = Qpeak(1:datesize(1),4);
    
    % Days of event peak at the three gauges
    k123 = (k-1)*3+1;
    Qpeakdate(:,k123:k123+2) = Qpeak(1:datesize(1),1:3);
    
    % Event start and end of these days of the year
    Qstartdate(:,k) = QindSdate(1:datesize(1),1);
    Qenddate(:,k) = QindEdate(1:datesize(1),1);

    % Event centroid: X value (time)
    Centroid_X(:,k) = x_centroid(1:datesize(1));
    % Event centroid: Y value (discharge without base flow)
    Centroid_Y(:,k) = y_centroid(1:datesize(1));
    % Event centroid: Y value (discharge with base flow)
    Centroid_Ytotal(:,k) = ytotal_centroid(1:datesize(1));
    
    % Event volume
    Qvolume(:,k) = Qvol(1:datesize(1));
    
end

%Example for saving path
savepath = 'F:\bfguse\Daten_Auswertung\Flood wave superposition\Sergiy_tool\';
% save all events for each of the three triples
    dlmwrite ([savepath 'event_down.txt'] ,eventmat_down,'delimiter', '\t', 'precision', '%g%g%g%g%g%g', 'newline', 'pc');
    dlmwrite ([savepath 'event_up.txt'] ,eventmat_up,'delimiter', '\t', 'precision', '%g%g%g%g%g%g', 'newline', 'pc');
    dlmwrite ([savepath 'event_trib.txt'] ,eventmat_trib,'delimiter', '\t', 'precision', '%g%g%g%g%g%g', 'newline', 'pc');
        
figure;
plot(QbaseG)

end
