%% Function to calculate annual maxima series
% Contact:
% Sergiy Vorogushyn, Bjrn Guse and Bruno Merz
% sergiy.vorogushyn@gfz-potsdam.de, bjrn.guse@gfz-potsdam.de,
% bruno.merz@gfz-potsdam.de
% GFZ German Research Centre for Geosciences, Hydrology Section, Telegrafenberg, Potsdam, Germany

function [ams,amsdate] = Annual_maxima_series(d, m, y, q)
% detection of AMS (=Annual Maximum Series) for a hydrologic year
% (1 nov - 31 oct)
%  
% Input:    date:   date (vector with strings: dd.mm.yyyy)
%           q:      daily time series (vector)
% Output:   ams:    ams series
%           amsdate:date of ams values

% conversion if string to numbers for day, month, year
% d=str2num(date(:,1:2));
% m=str2num(date(:,4:5));
% y=str2num(date(:,7:10));

% find all beginnings and ends of hydrologic years
% annual AMS
i1 = find(d==1 & m==11);
i2 = find(d==31 & m==10);

% % extract data and discharge of hydrologic years
% n = length(i2);
% d = d(i1(1):i2(n));
% m = m(i1(1):i2(n));
% y = y(i1(1):i2(n));
% q = q(i1(1):i2(n));
% % date1 = datenum(y,m,d);

% AMS values
ams = [];
amsdate = []; 

%minimum time window (days) between two peaks in two different years
t_window = 7;
 
% maximum daily discharge of each year
for i = 1:length(i1);
    k = 0;
    
    % Peaks within hydrological year
    [a,jj] = findpeaks(q(i1(i):i2(i)));    
    [max_peak,loc] = max(a);
            
    % Check the case if the AMS peak falls exactly either on 30.10. or
    % 1.11. This peak will not be captured by findpeaks function.
    % Check neighbouring values
    
    if (i ~= 1) && ((max(findpeaks(q(i1(i)-1:i2(i))))) > max_peak)
        % The peak is on 1.11.; take this peak
        [a,jj] = findpeaks(q(i1(i)-1:i2(i)));
        [max_peak,loc] = max(a);
        jj(loc) = jj(loc)-1;
        
    elseif (i~=length(i1)) && ((max(findpeaks(q(i1(i):i2(i)+1)))) > max_peak)
        %the peak is on 30.10.; take this peak
        [a,jj] = findpeaks(q(i1(i):i2(i)+1));
        [max_peak,loc] = max(a);
    end
        
    %make sure the selected peak is at least t_window days from previous' year peak
    while ((i~=1) && ((datenum(y(i1(i)+jj(loc)-1), m(i1(i)+jj(loc)-1), d(i1(i)+jj(loc)-1)) - ...
            datenum(amsdate(end), amsdate(end-1), amsdate(end-2))) < t_window))
       % select the the next highest peak
       out = sort(a, 'descend');
       max_peak = out(2+k);
       loc = find(a == max_peak);
              
       % if there is more than one local maximum, take the first one
       if(length(loc) > 1)
           loc = loc(1);
       end
       
       k=k+1
    end
        
    ams = [ams max_peak];
    amsdate = [amsdate d(i1(i)+jj(loc)-1) m(i1(i)+jj(loc)-1) y(i1(i)+jj(loc)-1)];
    
end
  
ams = ams';
amsdate = amsdate';
amsdate = reshape(amsdate,3,[])';
   
end

