%This script first creates the unstressed helptable, and saves it, for both 
%scenarios (Energy Balance based and Soil water content based). 

%Second, the Ep is calculated based on this dataset, for the different
%methods mentioned in the manuscript. 
%
% The scripts requires as input files per site a DailyFlux file, which is a
% structure file with all daily fluxes, weather conditions, ... as a
% separate vector within the flux (see example) and an Ecosystem file (at
% the same location) with basic information on vegetation type (also in a
% structure, Ecosystem.VegType). % The DailyFlux and Ecosystem files need to be named as
% SITENAME_DailyFlux.mat and SITENAME_Ecosystem.mat, with SITENAME the
% standard FLUXNET sitename (e.g. AU-How).

% Additionally, you need to provide as input the data of the reference
% values per biome (VegTypeMax_EF.mat and VegTypeMax_SWC.mat, for the 
%energy balance-based approach and the soil water content based approach, respectively), calculated
% from the Unstressed Tables (UT and UT_S). These tables are calculated
% from the entire dataset; for this testcase, we added them.


LocDaily = 'D:\Users\womaes\Documents\Art_ETp\Submission_HESS\Resubmission2\'; %Location with the DailyFlux input file
LocResults = 'D:\Users\womaes\Documents\Art_ETp\Submission_HESS\Resubmission2\Out\';%Location where you want to output the overview tables 
LocETPot = 'D:\Users\womaes\Documents\Art_ETp\Submission_HESS\Resubmission2\Out\';%Location where you want to output the ETPot file

%Load VegType datasets
load([LocDaily 'VegType_EF.mat']);
load([LocDaily 'VegType_SWC.mat']);


mkdir(LocResults); mkdir(LocETPot); 

DirEco = dir([LocDaily '*_Ecosystem.mat']);

%Convert DirEco
DirEco=struct2cell(DirEco); DirEco=DirEco';


%% First part: calculate unstressed helptable per site.

for i1 =1:size(DirEco,1)
         SiteName = DirEco{i1,1}(1:6);
         %Load Ecosystem Table
         load([LocDaily DirEco{i1,1}]);
         
        %load daily table
        load([LocDaily SiteName '_DailyFlux.mat']);
        

  %% Subsection => calculate preparation for Thorntwaite method (I)      
        Dvec = datevec(DailyFlux.Date);
            Tmonth = nan(12,1);

            I=0;NoFullYear=0;
            for i2 = 1:12
                IndM = find(Dvec(:,2) == i2);
                if ~isempty(IndM)
                    Tmonth(i2) = nanmean(DailyFlux.Tair_DayNight(IndM));
                    if Tmonth(i2) >0
                        I = I + (Tmonth(i2)/5).^1.514;
                    end
                else
                    NoFullYear = 1;
                end  
            end
            if sum(isnan(Tmonth))>1
                Ecosystem.Thorntwaite.NoFullYear = 1;
            else
                Ecosystem.Thorntwaite.I = I;
                Ecosystem.Thorntwaite.a = 6.75.*10.^-7.*I.^3 -7.71.*10.^-5.*I.^2+1.7912.*10^-2.*I + .49239;
            end

   
        
        
        
        %Create an Unstressed Table, called UT
        %Reduce to useful data only
        FieldList = fields(DailyFlux);
        Ind1 = find(~isnan(DailyFlux.EF_DailyAv+DailyFlux.raH_DailyAv+DailyFlux.SWin + DailyFlux.NetRad+DailyFlux.G+DailyFlux.VPD+DailyFlux.Gamma_DailyAv+DailyFlux.Delta_DailyAv+DailyFlux.Wind) & DailyFlux.gC_DailyAv >0);
        for i2=1:length(FieldList)
            UT.(FieldList{i2,1})=DailyFlux.(FieldList{i2,1})(Ind1);
        end
        
        clear Ind1
        
        if length(UT.Tair)>80      %At least 80 days per tower needed       

                        % Select the highest EF. 
                          %B: Select the most unstressed days: 5% Days with highest EF -
                          %or, if 5% is less than 15 days, the 15 days with highest EF in
                          %the record.
                          [~,sortr] = sortrows(UT.EF_DailyAv,-1);
                          sortr=sortr(1:max(15,floor(0.05*length(UT.EF_DailyAv))));
                          for i2=1:length(FieldList)
                                UT.(FieldList{i2,1})=UT.(FieldList{i2,1})(sortr);
                          end
                          clear sortr
                          
 
                          %Save ETPot Table
                            
                            NameTable = strcat(SiteName,'_UT_EF.mat');
                            save([LocETPot NameTable],'UT','-v7.3');
        end          
                            
%% Second scenario: use the SCM, if available, to define unstressed: - the UT table is called UT_S
                        % - Select the 20-percentiles of LE; 
                        % - Select 'unstressed tble calculate
                        % highest 5% SM data per percentile as 
                        

                        %First: only retain Non-isnan values from SWC and
                        %LE                      
                        Ind_SWC = find(~isnan(DailyFlux.SWC+DailyFlux.LE+DailyFlux.raH_DailyAv+DailyFlux.SWin + DailyFlux.NetRad+DailyFlux.G+DailyFlux.VPD+DailyFlux.Gamma_DailyAv+DailyFlux.Delta_DailyAv+DailyFlux.Wind) & DailyFlux.gC_DailyAv >0);
      
          
                        if length(Ind_SWC) > 80 %At least 80 days
                            
                            for i2=1:length(FieldList)
                                UT_S.(FieldList{i2,1})=DailyFlux.(FieldList{i2,1})(Ind_SWC);
                            end
                            
 % LE-version                            
                            PT = [prctile(UT_S.LE,20); prctile(UT_S.LE,40);prctile(UT_S.LE,60);prctile(UT_S.LE,80)];
                            DistLE = nan(size(UT_S.LE));DistLE(:) = 5; DistLE(UT_S.LE<PT(4))=4;DisLE(UT_S.LE<PT(3))=3;DistLE(UT_S.LE<PT(2))=2;DistLE(UT_S.LE<PT(1))=1;
                     
                            %Criteria: split the evapotranspiration up into 5 classes
                            %(based on distribution). Of each class, except the bottom class, select
                            %days with 5% highest SWC, but the 95%
                            %percentile needs to be higher than
                            %.75*(98%percentile) of overall data .Only keep
                            %if there's over 15 of those days
                            RefSWC = prctile(UT_S.SWC,98);
                            IndSel = [];
                           % for i3=2:5
                            for i3=2:5   % Lowest percentile not taken into account...
                                IndH = find(DistLE(:) ==i3 & UT_S.SWC(:)> .75*RefSWC & UT_S.SWC(:)> prctile(UT_S.SWC(DistLE(:) ==i3),95));

                                    IndSel = [IndSel; IndH];
                               
                            end

                            
               if length(IndSel)>15             
                             for i2=1:length(FieldList)
                                UT_S.(FieldList{i2,1})=UT_S.(FieldList{i2,1})(IndSel);
                             end 
                             
  
                   %Save ETPot Table
                            
                            NameTable = strcat(SiteName,'_UT_SWC.mat');
                            save([LocETPot NameTable],'UT_S','-v7.3');    
                             
               end
           end
%% Assign the mean EFMax, ... values

 Ecosystem.VegTypeClas = cell(7,3);
        Ecosystem.VegTypeClas{1,2} = 'VegType_EF';
        Ecosystem.VegTypeClas{1,3} = 'VegType_SWC';
        Ecosystem.VegTypeClas{2,1} = 'AlfaMD';
        Ecosystem.VegTypeClas{3,1} = 'AlfaPT';
        Ecosystem.VegTypeClas{4,1} = 'Gc_ref';
        Ecosystem.VegTypeClas{5,1} = 'AlfaOudin';
        Ecosystem.VegTypeClas{6,1} = 'AlfaThorn';
        Ecosystem.VegTypeClas{7,1} = 'AlfaHS';

        VegInd_EF = find(strcmp(Ecosystem.VegType, VegTypeMax_EF(:,1))); 
        Ecosystem.VegTypeClas{2,2} = VegTypeMax_EF{VegInd_EF,3};
        Ecosystem.VegTypeClas{3,2} = VegTypeMax_EF{VegInd_EF,7};
        Ecosystem.VegTypeClas{4,2} = VegTypeMax_EF{VegInd_EF,5};
        Ecosystem.VegTypeClas{5,2} = VegTypeMax_EF{VegInd_EF,9};
        Ecosystem.VegTypeClas{6,2} = VegTypeMax_EF{VegInd_EF,15};
         Ecosystem.VegTypeClas{7,2} = VegTypeMax_EF{VegInd_EF,11};
        
        VegInd = find(strcmp(Ecosystem.VegType, VegTypeMax_SWC(:,1))); 
        if ~isempty(VegInd)
            Ecosystem.VegTypeClas{2,3} = VegTypeMax_SWC{VegInd,3};
            Ecosystem.VegTypeClas{3,3} = VegTypeMax_SWC{VegInd,7};
            Ecosystem.VegTypeClas{4,3} = VegTypeMax_SWC{VegInd,5};
            Ecosystem.VegTypeClas{5,3} = VegTypeMax_SWC{VegInd,9};
            Ecosystem.VegTypeClas{6,3} = VegTypeMax_SWC{VegInd,15};
            Ecosystem.VegTypeClas{7,3} = VegTypeMax_SWC{VegInd,11};
        end




%% Part 2 : calculate Ep for all different Ep scenarios
           
             %Record LE
             ETPot_EF.LE_Unstr_Wm = UT.LE;
             ETPot_EF.LE_Unstr_mmDay = UT.LE_SumDayTime;
             
             %% P1: Penman-Monteith based models
             
             %P1.1: General PM: FAO model
             %FAO98
                   Wind_FAO = nan(size(UT.Tair));
                   Tair_FAO = nan(size(UT.Tair));
                   es_FAO = nan(size(UT.Tair));
                   ea_FAO = nan(size(UT.Tair));
                   Delta_FAO = nan(size(UT.Tair));
                   Gamma_FAO = nan(size(UT.Tair));
                   raH_FAO = nan(size(UT.Tair));
                   LW_FAO  = nan(size(UT.Tair));
                  %Makes use of albedo = 23%

                  
                   Wind_FAO = 4.87.*UT.Wind./log(67.8.*UT.TowerHeight-5.42); %Eq 47 P91 FAO
                   
                   Tair_FAO = .5.*UT.TairMinDayTime+.5.*UT.TairMaxDayTime;
                   e0Tmin = nan(size(UT.Tair));
                   e0Tmax = nan(size(UT.Tair));
                   
                   e0Tmin = .6108.*exp(17.27.*UT.TairMinDayTime./(273.3 + UT.TairMinDayTime));
                   e0Tmax = .6108.*exp(17.27.*UT.TairMaxDayTime./(273.3 + UT.TairMaxDayTime));
                   
                   es_FAO = .5.*e0Tmin+.5.*e0Tmax; %P68, Eq12
                   ea_FAO = (e0Tmin.*.01.*UT.RHmax +e0Tmax.*.01.*UT.RHmin)./2; %P71 Eq. 17
                   
                   Delta_FAO = 4098.*0.6108.*exp(17.27.*Tair_FAO./(Tair_FAO + 237.3))./(Tair_FAO + 237.3).^2; %Eq13 p 69 in kPa/C
                   Gamma_FAO = .665.*10^-6.*UT.Press; %Eq8 p63 ! in Eq8, it's 10^-3, but Press is in kPa, in our measurements, Press is in Pa
                   Gamma_FAO(isnan(UT.Press)) = .665.*10^-3.*101.3.*((293-.0065.*Ecosystem.location.altitude)./293).^5.26; %Eq. 7 p62
                    
                   
                   clear eoTmin eoTmax
                   %SW of FAO
                   SWin_FAO = UT.SWin_SumDayTime;
                   
                   %LongWave of FAO
                   LW_FAO = nan(size(UT.Tair));
                   Rso = nan(size(UT.Tair));
                   Rso = (.75 + 2.*10.^-5.*Ecosystem.location.altitude).*UT.RextraTerr; %Eq37 p85
                   LW_FAO =4.903.*10.^-9.*.5.*((273.15 + UT.TairMinDayTime).^4+(273.15 + UT.TairMaxDayTime).^4).*(0.34 -0.14.*ea_FAO.^0.5).*(1.35.*SWin_FAO./Rso -0.35); %Eq39 p 86                   
                   LW_FAO(SWin_FAO>Rso) =4.903.*10.^-9.*((273.15 + UT.TairMinDayTime(SWin_FAO>Rso)).^4+(273.15 + UT.TairMaxDayTime(SWin_FAO>Rso)).^4)./2.*(.34 -.14.*ea_FAO(SWin_FAO>Rso).^.5); %See condition: Rs/Rso <=1
                   
                   %NetRad FAO
                   NetRad_FAO = SWin_FAO.*(1-.23) + LW_FAO;
                   
              %Reference ETpot (FAO-method)
                   ETPot_EF.PM_r = nan(size(UT.Tair)); % In MM/DAY
                   %try
                 
                   ETPot_EF.PM_r = (0.408.*Delta_FAO.*NetRad_FAO + Gamma_FAO.*900.*Wind_FAO.*(es_FAO-ea_FAO)./(Tair_FAO+273.15))./...
                           (Delta_FAO + Gamma_FAO.*(1+0.34.*Wind_FAO)); %Eq 6 Ch2 FAO
             
             %P1.2: Standard PM: rc = fixed (69)
                      ETPot_EF.PM_s = nan(size(UT.Tair)); % In W/m
                      Ind = find(~isnan(UT.VPD+UT.raH_DailyAv+UT.NetRad+UT.Tair+UT.G));
                      ETPot_EF.PM_s(Ind,1)= (...
                            UT.Delta_DailyAv(Ind,1).*(UT.NetRad(Ind,1)-UT.G(Ind,1))+...                 
                            UT.Rho_a_DailyAv(Ind,1).*1012.*UT.VPD(Ind,1)./UT.raH_DailyAv(Ind,1)...
                                ) ... 
                           ./(UT.Delta_DailyAv(Ind,1)+UT.Gamma_DailyAv(Ind,1) + UT.Gamma_DailyAv(Ind,1).*(70./UT.raH_DailyAv(Ind,1))); %rc=70
                       %Convert to mm/Day
                       ETPot_EF.PM_s =ETPot_EF.PM_s.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6);
              
                 %P1.3: Biome specific PM: rc = f(Biome)
                 ETPot_EF.PM_b = nan(size(UT.Tair));        
                 ETPot_EF.PM_b(Ind,1)= (...
                               UT.Rho_a_DailyAv(Ind,1).*1012.*UT.VPD(Ind,1)./UT.raH_DailyAv(Ind,1) + ...
                               UT.Delta_DailyAv(Ind,1).*(UT.NetRad(Ind,1)-UT.G(Ind,1))...
                               ) ... 
                               ./(UT.Delta_DailyAv(Ind,1)+UT.Gamma_DailyAv(Ind,1) + UT.Gamma_DailyAv(Ind,1).*(1000./(Ecosystem.VegTypeClas{4,2}.*UT.raH_DailyAv(Ind,1))));
                 %Convert to mm/Day
                 ETPot_EF.PM_b =ETPot_EF.PM_b.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6);  


           
            %% P2: Penman based models (rc=0);

                %P2.1: Penman, reference => based on FAO-variables
                ETPot_EF.Pe_r =nan(size(UT.Tair)); %IN MM/DAY          
                ETPot_EF.Pe_r = 0.408.*Delta_FAO.*NetRad_FAO./(Delta_FAO + Gamma_FAO)...
                             + Gamma_FAO.*900.*Wind_FAO.*(es_FAO-ea_FAO)./((Tair_FAO+273.15).*(Delta_FAO + Gamma_FAO));
                 
                %P2.1: Penman, Standard
                ETPot_EF.Pe_s = nan(size(UT.Tair)); %IN W/M
                ETPot_EF.Pe_s = (UT.Delta_DailyAv(Ind,1).*(UT.NetRad(Ind,1)-UT.G(Ind,1))+ ...                 
                            UT.Rho_a_DailyAv(Ind,1).*1012.*UT.VPD(Ind,1)./UT.raH_DailyAv(Ind,1))... 
                           ./(UT.Delta_DailyAv(Ind,1)+UT.Gamma_DailyAv(Ind,1)); %rc=0
                 %Convert to mm/Day
                 ETPot_EF.Pe_s =ETPot_EF.Pe_s.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6);   
                       
                %% P3: Priestly & Taylor
                %P3.1 Reference, using the same FAO-based radiation
                ETPot_EF.PT_r = nan(size(UT.Tair));  %IN MM/DAY
                ETPot_EF.PT_r = 1.26.*0.408.*Delta_FAO.*NetRad_FAO./(Delta_FAO + Gamma_FAO);
                
                %P3.2 Standard
                ETPot_EF.PT_s = nan(size(UT.Tair));  %IN W/M
                ETPot_EF.PT_s = 1.26.*UT.Delta_DailyAv(Ind,1).*(UT.NetRad(Ind,1)-UT.G(Ind,1))...                 
                            ./(UT.Delta_DailyAv(Ind,1)+UT.Gamma_DailyAv(Ind,1));
                %Convert to mm/Day
                 ETPot_EF.PT_s =ETPot_EF.PT_s.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6); 
                
                %P3.3 Biome specific
                ETPot_EF.PT_b = nan(size(UT.Tair));
                ETPot_EF.PT_b = Ecosystem.VegTypeClas{3,2}.*UT.Delta_DailyAv(Ind,1).*(UT.NetRad(Ind,1)-UT.G(Ind,1))...                 
                            ./(UT.Delta_DailyAv(Ind,1)+UT.Gamma_DailyAv(Ind,1)); 
                %Convert to mm/Day
                ETPot_EF.PT_b =ETPot_EF.PT_b.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6); 
                        
                        
                %% P4: Milly and Dunne
                %4.1 Reference
                ETPot_EF.MD_r = nan(size(UT.Tair));
                ETPot_EF.MD_r = .8.*0.408.*NetRad_FAO; %mm/Day
                
                %4.2 Standard
                ETPot_EF.MD_s = nan(size(UT.Tair)); %W/m2
                ETPot_EF.MD_s = .8.*(UT.NetRad(Ind,1)-UT.G(Ind,1));
                %convert to mm/day
                ETPot_EF.MD_s = ETPot_EF.MD_s.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6);
                
                %4.3 biome specific
                ETPot_EF.MD_b = nan(size(UT.Tair));
                ETPot_EF.MD_b = Ecosystem.VegTypeClas{2,2}.*(UT.NetRad(Ind,1)-UT.G(Ind,1));
                %convert to mm/day
                ETPot_EF.MD_b = ETPot_EF.MD_b.*3600.*UT.NrDayLight./(UT.Lambda_DailyAv.*10.^6);
                
                %% P5: Thorntwaite
                %P5.1_Standard
                 ETPot_EF.Th_s = nan(size(UT.Tair)); % In MM/DAY
                  
                Teff = nan(size(UT.Tair));
                Teff = 0.36.*(3.*UT.TairMaxDayNight - UT.TairMinDayNight).*UT.NrDayLight./(24-UT.NrDayLight);
                Tav = (0.5.*UT.TairMaxDayNight + .5.*UT.TairMinDayNight);
                Teff(Teff<Tav)=Tav(Teff<Tav);
                Teff(Teff>UT.TairMaxDayNight)=UT.TairMaxDayNight(Teff>UT.TairMaxDayNight);
                    
                if isfield(Ecosystem.Thorntwaite, 'I')
                    ETPot_EF.Th_s(Teff>0 & Teff<=26)=16.*(10.*Teff(Teff>0 & Teff<=26)./Ecosystem.Thorntwaite.I).^Ecosystem.Thorntwaite.a.*UT.NrDayLight(Teff>0 & Teff<=26)./360;
                    ETPot_EF.Th_s(Teff>26) = (-415.85 + 32.24.*Teff(Teff>26)-0.43.*Teff(Teff>26).^2).*UT.NrDayLight(Teff>26)./360;
                end
                 
                 
                %P5.2 Biome specific => change factor of 16 (AlfaTh)
                ETPot_EF.Th_b = nan(size(UT.Tair)); % In MM/DAY
                if isfield(Ecosystem.Thorntwaite, 'I')
                    ETPot_EF.Th_b(Teff>0 & Teff<=26)=Ecosystem.VegTypeClas{6,2}.*(10.*Teff(Teff>0 & Teff<=26)./Ecosystem.Thorntwaite.I).^Ecosystem.Thorntwaite.a.*UT.NrDayLight(Teff>0 & Teff<=26)./360;
                    ETPot_EF.Th_b(Teff>26) = (-415.85 + 32.24.*Teff(Teff>26)-0.43.*Teff(Teff>26).^2).*UT.NrDayLight(Teff>26)./360;
                end
                 
                
                %% P6:Oudin 
                %P6.1: Standard % In MM/DAY
                ETPot_EF.Ou_s = nan(size(UT.Tair));
                    Lambda = 2.501 - 2.361 .* 10.^-3.*UT.Tair_DayNight;
                ETPot_EF.Ou_s=UT.RextraTerr.*(UT.Tair_DayNight+5)./(Lambda.*100); %(correct, rho is not missing, it has been converted to the correct units=1
                ETPot_EF.Ou_s(UT.Tair_DayNight<5)=0;
 
                %P6.2:biome specific % In MM/DAY
                ETPot_EF.Ou_b = nan(size(UT.Tair));
                if ~isnan(Ecosystem.VegTypeClas{5,2})
                ETPot_EF.Ou_b=UT.RextraTerr.*(UT.Tair_DayNight+5)./(Lambda.*Ecosystem.VegTypeClas{5,2}); %(correct, rho is not missing, it has been converted to the correct units=1
                ETPot_EF.Ou_b(UT.Tair_DayNight<5)=0;
                end
                
                %% P7: Hargreaves-Samani
                %P7.1: Standard % In MM/DAY
                ETPot_EF.HS_s = nan(size(UT.Tair));
                    
                ETPot_EF.HS_s=UT.RextraTerr.*0.0023.*(UT.Tair_DayNight+17.8).*(UT.TairMaxDayNight - UT.TairMinDayNight).^0.5./(Lambda); %(correct, rho is not missing, it has been converted to the correct units=1

 
                %P7.2:Biome-specific % In MM/DAY
                ETPot_EF.HS_b = nan(size(UT.Tair));
                if ~isnan(Ecosystem.VegTypeClas{6,2})
                    ETPot_EF.HS_b=Ecosystem.VegTypeClas{6,2}.*UT.RextraTerr.*(UT.Tair_DayNight+17.8).*(UT.TairMaxDayNight - UT.TairMinDayNight).^0.5./(Lambda);; %(correct, rho is not missing, it has been converted to the correct units=1

                end
        
                
                
        
            clear Lambda Teff Tav LW_FAO Tair_FAO Delta_FAO LeNAN  SWin_FAO Wind_FAO i    
        
            
  
                  %Save ETPot Table
                    NameTable = strcat(SiteName,'_ETPot_EF.mat');
                    save([LocETPot NameTable],'ETPot_EF','-v7.3');       



clear raH_FAO NetRad_FAO Gamma_FAO es_FAO ea_FAO 

%% Repeat loop for all sites which also have soil moisture data
            

             %Record LE
             ETPot_SWC.LE_Unstr_Wm = UT_S.LE;
             ETPot_SWC.LE_Unstr_mmDay = UT_S.LE_SumDayTime;
             
             %% P1: Penman-Monteith based models
             
             %P1.1: General PM: FAO model
             %FAO56 method to which we refer is Allen et al, 1998, FAO56 - https://appgeodb.nancy.inra.fr/biljou/pdf/Allen_FAO1998.pdf

                   Wind_FAO = nan(size(UT_S.Tair));
                   Tair_FAO = nan(size(UT_S.Tair));
                   es_FAO = nan(size(UT_S.Tair));
                   ea_FAO = nan(size(UT_S.Tair));
                   Delta_FAO = nan(size(UT_S.Tair));
                   Gamma_FAO = nan(size(UT_S.Tair));
                   raH_FAO = nan(size(UT_S.Tair));
                   LW_FAO  = nan(size(UT_S.Tair));
                  %Makes use of albedo = 23%
                   Wind_FAO = 4.87.*UT_S.Wind./log(67.8.*UT_S.TowerHeight-5.42); %Eq 47 P91 FAO   
                   Tair_FAO = .5.*UT_S.TairMinDayTime+.5.*UT_S.TairMaxDayTime;
                   e0Tmin = nan(size(UT_S.Tair));
                   e0Tmax = nan(size(UT_S.Tair));
                     e0Tmin = .6108.*exp(17.27.*UT_S.TairMinDayTime./(273.3 + UT_S.TairMinDayTime));
                   e0Tmax = .6108.*exp(17.27.*UT_S.TairMaxDayTime./(273.3 + UT_S.TairMaxDayTime));                  
                   es_FAO = .5.*e0Tmin+.5.*e0Tmax; %P68, FAO Eq12
                   ea_FAO = (e0Tmin.*.01.*UT_S.RHmax +e0Tmax.*.01.*UT_S.RHmin)./2; %P71 Eq. 17
                   Delta_FAO = 4098.*0.6108.*exp(17.27.*Tair_FAO./(Tair_FAO + 237.3))./(Tair_FAO + 237.3).^2; %Eq13 FAO p 69 in kPa/C
                   Gamma_FAO = .665.*10^-6.*UT_S.Press; %Eq8 FAO p63 ! in Eq8, it's 10^-3, bUT_S Press is in kPa, in our measurements, Press is in Pa
                   Gamma_FAO(isnan(UT_S.Press)) = .665.*10^-3.*101.3.*((293-.0065.*Ecosystem.location.altitude)./293).^5.26; %Eq. 7 FAO p62
                    
                   
                   clear eoTmin eoTmax
                   %SW of FAO
                   SWin_FAO = UT_S.SWin_SumDayTime;
                   
                   %LongWave of FAO
                   LW_FAO = nan(size(UT_S.Tair));
                   Rso = nan(size(UT_S.Tair));
                   Rso = (.75 + 2.*10.^-5.*Ecosystem.location.altitude).*UT_S.RextraTerr; %Eq37 p85 FAO; RextraTerr refers to Ra in FAO, see Eq. 21 Ch 3 (P79)
                   LW_FAO =4.903.*10.^-9.*.5.*((273.15 + UT_S.TairMinDayTime).^4+(273.15 + UT_S.TairMaxDayTime).^4).*(0.34 -0.14.*ea_FAO.^0.5).*(1.35.*SWin_FAO./Rso -0.35); %Eq39 p 86                   
                   LW_FAO(SWin_FAO>Rso) =4.903.*10.^-9.*((273.15 + UT_S.TairMinDayTime(SWin_FAO>Rso)).^4+(273.15 + UT_S.TairMaxDayTime(SWin_FAO>Rso)).^4)./2.*(.34 -.14.*ea_FAO(SWin_FAO>Rso).^.5); %See condition: Rs/Rso <=1
                   
                   %NetRad FAO
                   NetRad_FAO = SWin_FAO.*(1-.23) + LW_FAO;
                   
              %ETpot Reference 
                   ETPot_SWC.PM_r = nan(size(UT_S.Tair)); % In MM/DAY
                   %try
                 
                   ETPot_SWC.PM_r = (0.408.*Delta_FAO.*NetRad_FAO + Gamma_FAO.*900.*Wind_FAO.*(es_FAO-ea_FAO)./(Tair_FAO+273.15))./...
                           (Delta_FAO + Gamma_FAO.*(1+0.34.*Wind_FAO));
             
             %P1.2: Standard: rc = fixed (69)
                      ETPot_SWC.PM_s = nan(size(UT_S.Tair)); % In W/m
                      Ind = find(~isnan(UT_S.VPD+UT_S.raH_DailyAv+UT_S.NetRad+UT_S.Tair+UT_S.G));
                      ETPot_SWC.PM_s(Ind,1)= (...
                            UT_S.Delta_DailyAv(Ind,1).*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1))+...                 
                            UT_S.Rho_a_DailyAv(Ind,1).*1012.*UT_S.VPD(Ind,1)./UT_S.raH_DailyAv(Ind,1)...
                                ) ... 
                           ./(UT_S.Delta_DailyAv(Ind,1)+UT_S.Gamma_DailyAv(Ind,1) + UT_S.Gamma_DailyAv(Ind,1).*(69./UT_S.raH_DailyAv(Ind,1))); %rc=70
                       %Convert to mm/Day
                       ETPot_SWC.PM_s =ETPot_SWC.PM_s.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6);
              
                 %P1.3: Biome specific: rc = f(VT)
                 ETPot_SWC.PM_b = nan(size(UT_S.Tair));        
                 ETPot_SWC.PM_b(Ind,1)= (...
                               UT_S.Rho_a_DailyAv(Ind,1).*1012.*UT_S.VPD(Ind,1)./UT_S.raH_DailyAv(Ind,1) + ...
                               UT_S.Delta_DailyAv(Ind,1).*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1))...
                               ) ... 
                               ./(UT_S.Delta_DailyAv(Ind,1)+UT_S.Gamma_DailyAv(Ind,1) + UT_S.Gamma_DailyAv(Ind,1).*(1000./(Ecosystem.VegTypeClas{4,3}.*UT_S.raH_DailyAv(Ind,1))));
                 %Convert to mm/Day
                 ETPot_SWC.PM_b =ETPot_SWC.PM_b.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6);  


      
           
            %% P2: Penman based models (rc=0);

                %P2.1: Penman, Reference => based on FAO-variables, see also
                %Oudin et al 2005b, bUT_S with 1/rah = 2.6(1+.536 U_2m)
                ETPot_SWC.Pe_r =nan(size(UT_S.Tair)); %IN MM/DAY  
                ETPot_SWC.Pe_r = 0.408.*Delta_FAO.*NetRad_FAO./(Delta_FAO + Gamma_FAO)...
                             + Gamma_FAO.*900.*Wind_FAO.*(es_FAO-ea_FAO)./((Tair_FAO+273.15).*(Delta_FAO + Gamma_FAO));
                 
                %P2.1: Penman, Standard
                ETPot_SWC.Pe_s = nan(size(UT_S.Tair)); %IN W/M
                ETPot_SWC.Pe_s = (UT_S.Delta_DailyAv(Ind,1).*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1))+ ...                 
                            UT_S.Rho_a_DailyAv(Ind,1).*1012.*UT_S.VPD(Ind,1)./UT_S.raH_DailyAv(Ind,1))... 
                           ./(UT_S.Delta_DailyAv(Ind,1)+UT_S.Gamma_DailyAv(Ind,1)); %rc=70
                 %Convert to mm/Day
                 ETPot_SWC.Pe_s =ETPot_SWC.Pe_s.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6);   
                       
                %% P3: Priestly & Taylor
                %P3.1 Reference, using the same FAO-based radiation
                ETPot_SWC.PT_r = nan(size(UT_S.Tair));  %IN MM/DAY
                ETPot_SWC.PT_r = 1.26.*0.408.*Delta_FAO.*NetRad_FAO./(Delta_FAO + Gamma_FAO);
                
                %P3.2 PT-s (Standard), 
                ETPot_SWC.PT_s = nan(size(UT_S.Tair));  %IN W/M
                ETPot_SWC.PT_s = 1.26.*UT_S.Delta_DailyAv(Ind,1).*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1))...                 
                            ./(UT_S.Delta_DailyAv(Ind,1)+UT_S.Gamma_DailyAv(Ind,1));
                %Convert to mm/Day
                 ETPot_SWC.PT_s =ETPot_SWC.PT_s.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6); 
                
                %P3.3 PT_b
                ETPot_SWC.PT_b = nan(size(UT_S.Tair));
                ETPot_SWC.PT_b = Ecosystem.VegTypeClas{3,3}.*UT_S.Delta_DailyAv(Ind,1).*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1))...                 
                            ./(UT_S.Delta_DailyAv(Ind,1)+UT_S.Gamma_DailyAv(Ind,1)); 
                %Convert to mm/Day
                ETPot_SWC.PT_b =ETPot_SWC.PT_b.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6); 
                        
                        
                %% P4: Milly & Dunne-based
                %4.1 Global
                ETPot_SWC.MD_r = nan(size(UT_S.Tair));
                ETPot_SWC.MD_r = .8.*0.408.*NetRad_FAO; %mm/Day
                
                %4.2 Standard
                ETPot_SWC.MD_s = nan(size(UT_S.Tair)); %W/m2
                ETPot_SWC.MD_s = .8.*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1));
                %convert to mm/day
                ETPot_SWC.MD_s = ETPot_SWC.MD_s.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6);
                
                %4.3 Biome-specific
                ETPot_SWC.MD_b = nan(size(UT_S.Tair));
                ETPot_SWC.MD_b = Ecosystem.VegTypeClas{2,3}.*(UT_S.NetRad(Ind,1)-UT_S.G(Ind,1));
                %convert to mm/day
                ETPot_SWC.MD_b = ETPot_SWC.SWC_V.*3600.*UT_S.NrDayLight./(UT_S.Lambda_DailyAv.*10.^6);
                
                %% P5: Thorntwaite
                %P5.1_ Standard
                 ETPot_SWC.Th_s = nan(size(UT_S.Tair)); % In MM/DAY
                  
                Teff = nan(size(UT_S.Tair));
                Teff = 0.36.*(3.*UT_S.TairMaxDayNight - UT_S.TairMinDayNight).*UT_S.NrDayLight./(24-UT_S.NrDayLight);
                Tav = (0.5.*UT_S.TairMaxDayNight + .5.*UT_S.TairMinDayNight);
                Teff(Teff<Tav)=Tav(Teff<Tav);
                Teff(Teff>UT_S.TairMaxDayNight)=UT_S.TairMaxDayNight(Teff>UT_S.TairMaxDayNight);
                    
                if isfield(Ecosystem.Thorntwaite, 'I')
                    ETPot_SWC.Th_s(Teff>0 & Teff<=26)=16.*(10.*Teff(Teff>0 & Teff<=26)./Ecosystem.Thorntwaite.I).^Ecosystem.Thorntwaite.a.*UT_S.NrDayLight(Teff>0 & Teff<=26)./360;
                    ETPot_SWC.Th_s(Teff>26) = (-415.85 + 32.24.*Teff(Teff>26)-0.43.*Teff(Teff>26).^2).*UT_S.NrDayLight(Teff>26)./360;
                end
                 
                 
                %P5.2 Biome-specific => change factor of 16 (AlfaTh)
                ETPot_SWC.Th_b = nan(size(UT_S.Tair)); % In MM/DAY
                if isfield(Ecosystem.Thorntwaite, 'I')
                    ETPot_SWC.Th_b(Teff>0 & Teff<=26)=Ecosystem.VegTypeClas{6,3}.*(10.*Teff(Teff>0 & Teff<=26)./Ecosystem.Thorntwaite.I).^Ecosystem.Thorntwaite.a.*UT_S.NrDayLight(Teff>0 & Teff<=26)./360;
                    ETPot_SWC.Th_b(Teff>26) = (-415.85 + 32.24.*Teff(Teff>26)-0.43.*Teff(Teff>26).^2).*UT_S.NrDayLight(Teff>26)./360;
                end
                 
                
                %% P6:Oudin 
                %P6.1: Standard % In MM/DAY
                ETPot_SWC.Ou_s = nan(size(UT_S.Tair));
                    Lambda = 2.501 - 2.361 .* 10.^-3.*UT_S.Tair_DayNight;
                ETPot_SWC.Ou_s=UT_S.RextraTerr.*(UT_S.Tair_DayNight+5)./(Lambda.*100); %(correct, rho is not missing, it has been converted to the correct units=1
                ETPot_SWC.Ou_s(UT_S.Tair_DayNight<5)=0;
 
                %P6.2: Biome-Specific % In MM/DAY
                ETPot_SWC.Ou_b = nan(size(UT_S.Tair));
                if ~isnan(Ecosystem.VegTypeClas{5,3})
                ETPot_SWC.Ou_b=UT_S.RextraTerr.*(UT_S.Tair_DayNight+5)./(Lambda.*Ecosystem.VegTypeClas{5,3}); %(correct, rho is not missing, it has been converted to the correct units=1
                ETPot_SWC.Ou_b(UT_S.Tair_DayNight<5)=0;
                end
        
                %% P7: Hargreaves-Samani
                %P7.1: Standard % In MM/DAY
                ETPot_SWC.HS_s = nan(size(UT_S.Tair));
               ETPot_SWC.HS_s=UT_S.RextraTerr.*0.0023.*(UT_S.Tair_DayNight+17.8).*(UT_S.TairMaxDayNight - UT_S.TairMinDayNight).^0.5./(Lambda); %(correct, rho is not missing, it has been converted to the correct units=1

                %P7.2:Biome-specific % In MM/DAY
                ETPot_SWC.HS_b = nan(size(UT.Tair));
                if ~isnan(Ecosystem.VegTypeClas{7,3})
                    ETPot_SWC.HS_b=Ecosystem.VegTypeClas{7,3}.*UT_S.RextraTerr.*(UT_S.Tair_DayNight+17.8).*(UT_S.TairMaxDayNight - UT_S.TairMinDayNight).^0.5./(Lambda); %(correct, rho is not missing, it has been converted to the correct units=1
                end
                
            clear Lambda Teff Tav LW_FAO Tair_FAO Delta_FAO LeNAN  SWin_FAO Wind_FAO i    
       
          %Save ETPot Table
                    NameTable = strcat(SiteName,'_ETPot_SWC.mat');
                    save([LocETPot NameTable],'ETPot_SWC','-v7.3');
                   
       
    end


