# ---------------------------------------------------
# Supplementary Code to reproduce Fig. 1
# ---------------------------------------------------

# Sebastian Sippel
# 31.08.2016
library(extRemes)

# function to make transparent colors:
make.transparent.color <- function(x, alpha = 80) {  
  temp = c(col2rgb(col = x))
  return(rgb(red=temp[1], green=temp[2], blue=temp[3], alpha=alpha, maxColorValue=256))
}

# Reproduction of Fig. 1a. Conceptual example, change in PDF:
# ---------------------------------------------
cur.param = c(1, 1, 0)
nref = 8
ngridcells = 10000
data.orig = sapply(1:ngridcells, FUN=function(x) {
  cur.revd = revd(n=16, loc=cur.param[1], scale=cur.param[2], shape = cur.param[3], type="GEV")
  # cur.revd[which(cur.revd < 0)] <- 0
  return(cur.revd)
})

mean.estimate = sapply(1:ngridcells, FUN=function(x) mean(data.orig[1:nref,x]))
data.anom = sapply(1:ngridcells, FUN=function(x) data.orig[,x] / mean.estimate[x])

# plot fig. 1a
plot(density(data.orig / mean(c(data.orig)), bw = 0.2), xlim=c(-1,4), ylim=c(0,0.6), main="", bty='n', col="black", xlab ="")
axis(side=1, at=seq(-1, 4, 0.2), labels=F, tcl =  -0.2)
axis(side=2, at=seq(0, 0.6, 0.02), labels=F, tcl =  -0.2)
lines(density(data.anom[9:16,], bw = 0.2), col="darkorange")
lines(density(data.anom[1:8,], bw = 0.2), col="cornflowerblue")
lines(x=rep(mean(data.anom[16,]), 2), y=c(0, 0.6), col="darkorange", lwd=1, lty = 2)
lines(x=rep(mean(data.anom[1,]), 2), y=c(0, 0.6), col="cornflowerblue", lwd=1, lty = 2)
arrows(x0= mean(data.anom[1,]), x1=mean(data.anom[16,]), y0=0, y1= 0, code = 2, length=0.03, col="black", lwd = 2)
arrows(x0= mean(data.anom[1,]), x1=mean(data.anom[16,]), y0=0.3, y1= 0.3, code = 2, length=0.03, col="black", lwd = 2)
arrows(x0= mean(data.anom[1,]), x1=mean(data.anom[16,]), y0=0.6, y1= 0.6, code = 2, length=0.03, col="black", lwd = 2)
legend("topright", c("Original PDF", "Ref. period PDF", "Out-of-base PDF"), col=c("black", "cornflowerblue", "darkorange"), lty = 1, lwd = 2, bty="n", cex = 0.8)


# Reproduction of Fig. 1b. Change in "mean" estimates in the reference and out-of-based period:
# ----------------------------------------------------------------

# Define parameters for normalization example:
cur.param = c(1, 1, 0)
nref = 30
sample.size = 10000
repetitions = 10 # in published figure repetitions are set to 100

data.cube.normalization = sapply(X=1:repetitions, FUN=function(idx) {
  ngridcells = sample.size
  
  # 1. sample from GEV:
    data.orig = sapply(1:ngridcells, FUN=function(x) revd(n=60, loc=cur.param[1], scale=cur.param[2], shape = cur.param[3], type="GEV"))
  # 2. derive estimates for the mean:
    mean.estimate = sapply(1:ngridcells, FUN=function(x) mean(data.orig[1:nref,x]))
    mean.estimate1 = mean(c(data.orig))
  # 3. normalize with the mean estimates:  
    data.anom = sapply(1:ngridcells, FUN=function(x) data.orig[,x] / mean.estimate[x])
  print(idx)
  return(c(apply(X=data.anom, MARGIN=1, FUN=mean), apply(X=data.orig / mean.estimate1, MARGIN=1, FUN=mean)))  
})

# plot figure 1b.:
plot(c(1,1), xlim=c(1,60), ylim = c(0.96, 1.06), bty='n', 
     ylab = "Mean of GEV", xlab ="Time", type='n')
polygon(x = c(1:60,60:1), y=c(apply(X=data.cube.normalization[61:120,], MARGIN=1, FUN=quantile, probs=c(0.05)), rev(apply(X=data.cube.normalization[61:120,], MARGIN=1, FUN=quantile, probs=c(0.95)))),
        col=make.transparent.color("black"), angle=45, density = 35, border = NA)
polygon(x = c(31:60,60:31), y=c(apply(X=data.cube.normalization[31:60,], MARGIN=1, FUN=quantile, probs=c(0.05)), rev(apply(X=data.cube.normalization[31:60,], MARGIN=1, FUN=quantile, probs=c(0.95)))),
        col=make.transparent.color("darkorange"), border = NA, density = 35, angle=15)
polygon(x = c(1:30,30:1), y=c(apply(X=data.cube.normalization[1:30,], MARGIN=1, FUN=quantile, probs=c(0.05)), rev(apply(X=data.cube.normalization[1:30,], MARGIN=1, FUN=quantile, probs=c(0.95)))),
        col=make.transparent.color("cornflowerblue"), border = NA, density = 35, angle=105)
lines(x = 1:60, y=apply(X=data.cube.normalization[61:120,], MARGIN=1, FUN=mean), col="black", lwd=2)
lines(x = 1:60, y=apply(X=data.cube.normalization[1:60,], MARGIN=1, FUN=mean), lwd=2, col = "darkgray")
lines(x = 31:60, y=apply(X=data.cube.normalization[31:60,], MARGIN=1, FUN=mean), col="darkorange", lwd=2)
lines(x = 1:30, y=apply(X=data.cube.normalization[1:30,], MARGIN=1, FUN=mean), col="cornflowerblue", lwd=2)
legend("topleft", c("Original time series", "Ref. period time series", "Normalized time series"), col = c("black", "cornflowerblue", "darkorange"), bty='n', lty =1, lwd = 2, cex = 0.8)

