function out_mat = mLocal_load1d(file_name,time_column,data_columns)
%MLOCAL_LOAD1D Function loads text/xls/tsf/mat data. 
% For xls/tsf/txt and mat file formats (xls requires Microsoft Excel)
% File format txt: header with % symbol. After header only numeric values.
% File format tsf: header as created by TSoft but no footer informations.
% File format xls: only numeric values will be considered.
% File format mat: simple matrix, not structure array.
% 
% Input:
%   file_name       ... full file name
%   time_columns    ... scalar specifying time column (except of tsf where
%                       the data+time are in first six colums)
%   data_columns    ... scalar or vector specifying loaded data columns
%                       (except of tsf where the data_columns are equal 
%                       to channel =>+6
% 
% Output:
%   out_mat         ... created matrix [time,data1,data2...]. Time is in
%                       matlab format (datenum)
% 

file_switch = file_name(end-2:end);
switch file_switch
    case 'txt'
        temp = load(file_name);
        out_mat = temp(:,[time_column,data_columns]);
    case 'tsf'
        fid = fopen(file_name);
        tline = fgetl(fid);header_lines = 0;
        if ~isempty(tline)
            while isnan(str2double(tline(1)))                   % determine number of header lines
                tline = fgetl(fid);
                try
                    if strcmp(char(tline(2:9)),'UNDETVAL')      % try to find flagged values
                        flagg = tline(11:end);
                        flagg = str2double(flagg);
                    end
                end
                if isempty(tline)
                    tline = 'mGlobe_RULEZ';
                end
            header_lines = header_lines + 1;
            end
        end
        fclose(fid);                                            % close the file to open it with known number of header lines
        temp = dlmread(file_name,'',header_lines,0);            % warning no footer info are allowed
        clear tline header_lines
        out_mat = [datenum(temp(:,1:6)),temp(:,data_columns+6)];
        if exist('flagg','var')
            try
                for gg = 2:size(out_mat,2)
                    r = find(out_mat(:,gg) == flagg);                      % remove flagged values
                    out_mat(r,gg) = NaN;
                    clear r
                end
            end
        end
        case 'TSF'
        fid = fopen(file_name);
        tline = fgetl(fid);header_lines = 0;
        if ~isempty(tline)
            while isnan(str2double(tline(1)))                   % determine number of header lines
                tline = fgetl(fid);
                try
                    if strcmp(char(tline(2:9)),'UNDETVAL')      % try to find flagged values
                        flagg = tline(11:end);
                        flagg = str2double(flagg);
                    end
                end
                if isempty(tline)
                    tline = 'mGlobe_RULEZ';
                end
            header_lines = header_lines + 1;
            end
        end
        fclose(fid);                                            % close the file to open it with known number of header lines
        temp = dlmread(file_name,'',header_lines,0);            % warning no footer info are allowed
        clear tline header_lines
        out_mat(:,1) = datenum(temp(:,1:6));
        out_mat(:,2:1+length(data_columns)) = temp(:,data_columns+6);
        if exist('flagg','var')
            try
                for gg = 2:size(out_mat,2)
                    r = find(out_mat(:,gg) == flagg);                      % remove flagged values
                    out_mat(r,gg) = NaN;
                    clear r
                end
            end
        end
    case 'xls'
        temp = xlsread(file_name);
        out_mat = temp(:,[time_column,data_columns]);
        
    case 'mat'
        temp = importdata(file_name);
        out_mat = temp(:,[time_column,data_columns]);
end


end

