%% Correct gravity for PCB effect and create one file for iGrav and SG030
addpath(fullfile('..','MatlabLibrary','hydroGravityLib'));
clear 
close all
clc

%% Main settings
% Input file containing gravity residuals
input_file.igrav = fullfile('..','..','Data','Grav','IGETS-IGRAV-RESHOUR-we006-ALL.tsf');
input_file.baro = fullfile('..','..','Data','Grav','IGETS-IGRAV-RESHOUR-we006-ALL.tsf');
input_file.sg030 = fullfile('..','..','Data','Grav','IGETS-SG-RESHOUR-we030-1-ALL.tsf');
% Set column with iGrav and SG030 residuals
input_column.igrav = 1;
input_column.sg030 = 1;
input_column.baro = 2;
% Set file containing PCB correction
input_file.pcb = fullfile('..','..','Data','HydroMeteo','IGETS-AUX-we006-ALL.tsf');
input_column.pcb = 6;
output_file = fullfile('..','..','Data','Grav','iGrav006_SG030_residuals.tsf');

%% Load data
in = {'igrav','sg030','baro','pcb'};
for i = 1:length(in)
    [temp_time,temp_data] = loadtsf(input_file.(in{i}));
    if i == 1
        time = temp_time;
        data = temp_data(:,input_column.(in{i}));
    elseif strcmp(in{i},'pcb')
        data(:,1) = data(:,1) + interp1(temp_time,temp_data(:,input_column.(in{i})),time);
    else
        data(:,i) = interp1(temp_time,temp_data(:,input_column.(in{i})),time);
    end
end

%% Write
writetsf([datevec(time),data],{'Wettzell','gravity','iGrav','nm/s^2';...
        'Wettzell','gravity','SG030','nm/s^2';...
        'Wettzell','iGrav006','Pressure','hPa'},output_file,3);
rmpath(fullfile('..','MatlabLibrary','hydroGravityLib'));