#
# Control file including all parameters!
# ALL parameters are constant in the 8 performed simulations described in Tabel 3!
# ONLY the vegetation parameterization differ between the 8 simulations (descriptions starts at line 841)!
# all parameterizations not needed are deleted, therefore it is not proffed if the control file is ready to be used to run simulations!!!
# in this control file the year 2013 in simulated, a spinup period is simulated prior with another control file (the years 2009-2012 here)!
# input data neccessary for modelling are NOT provided, because of data transfer restrictions!
# a detailed description of WaSim, including the control file, are given in the WaSim manual, which can be downloaded from http://www.wasim.ch


$set $mainpath       = # the main path has to be included here
$set $InitialStateDirectory  = $mainpath//Output2012\
$set $DefaultOutputDirectory = $mainpath//Output2013\
$set $inpath_grid    = $mainpath//input\
$set $inpath_meteo   = $mainpath//input\
$set $inpath_hydro   = $mainpath//input\
# $set $inpath_ini     = $mainpath//input\

$set $time           = 1440 # duration of a time step in minutes 1440min = 1day

$set $starthour      = 24
$set $startday       = 1
$set $startmonth     = 1
$set $startyear      = 2013
$set $endhour        = 24
$set $endday         = 31
$set $endmonth       = 12
$set $endyear        = 2013

# it is important to set $outpath to an empty string in order to activate $DefaultOutputDirectory
$set $outpath        =  

# readgrids : 1 = read storage grids (as SI, SSNOW,SLIQ...) from hard disk, 0=generate and initialize with 0
$set $readgrids      =  1

# read grids for dynamic phenology -> usually chilling grid should be read in if availabe because otherwise thermal time method will be applied and not the sequential model
$set $DPreadgrids    =  1 # should be 1 (manual p.165)

# == end of protected part ==

$set $year           = 13 # this is year

# it is important to set $outpath to an empty string in order to activate $DefaultOutputDirectory
$set $outpath        =  

$set $grid           =  plotReiff
$set $stack          =  plotReiff_stack
$set $suffix         =  grd
$set $code           =  s # as statistic file

# variables for standardgrids
# first section: grids, which differ for different subdivisions of the basin
$set $zone_grid             =  $grid//.e1
$set $subcatchments         =  $grid//.e2
$set $flow_time_grid        =  $grid//.fzs
$set $river_links_grid      =  $grid//.lnk
$set $regio_grid            =  $grid//.reg

# second section: grids, which doesn't depend on subdivision (only pixel-values are of interest)
$set $elevation_model       =  $grid//.dhm
$set $RelCellArea_grid      =  $grid//.rca
$set $CellSizeX_grid        =  $grid//.csx
$set $CellSizeY_grid        =  $grid//.csy
$set $slope_grid            =  $grid//.slp
$set $FlowDirection_grid    =  $grid//.fld
$set $aspect_grid           =  $grid//.exp
$set $land_use_grid         =  $grid//.use
$set $ice_firn_grid         =  $grid//.glc
$set $field_capacity_grid   =  $grid//.nfk
$set $ATBgrid               =  $grid//.atb
$set $hydr_cond_grid        =  $grid//.k
$set $soil_types            =  $grid//.soil
$set $sky_view_factor_grid  =  $grid//.hor
$set $drain_depth_grid      =  $grid//.drn
$set $drain_distance_grid   =  $grid//.dis
$set $irrigationcodes       =  $grid//.irr
$set $max_pond_grid         =  $grid//.maxpond
$set $clay_depth_grid       =  $grid//.cly
$set $river_depth_grid      =  $grid//.dep
$set $river_width_grid      =  $grid//.wit
$set $tracer_1              =  $grid//.c1
$set $tracer_2              =  $grid//.c2
$set $tracer_3              =  $grid//.c3
$set $tracer_4              =  $grid//.c4
$set $tracer_5              =  $grid//.c5
$set $tracer_6              =  $grid//.c6
$set $tracer_7              =  $grid//.c7
$set $tracer_8              =  $grid//.c8
$set $tracer_9              =  $grid//.c9
$set $kolmationsgrid        =  $grid//.kol
$set $gw_kx_1_grid          =  $grid//.kx1
$set $gw_kx_2_grid          =  $grid//.kx2
$set $gw_kx_3_grid          =  $grid//.kx3
$set $gw_ky_1_grid          =  $grid//.ky1
$set $gw_ky_2_grid          =  $grid//.ky2
$set $gw_ky_3_grid          =  $grid//.ky3
$set $gw_bound_h_1_grid     =  $grid//.bh1
$set $gw_bound_h_2_grid     =  $grid//.bh2
$set $gw_bound_h_3_grid     =  $grid//.bh3
$set $gw_bound_q_1_grid     =  $grid//.bq1
$set $gw_bound_q_2_grid     =  $grid//.bq2
$set $gw_bound_q_3_grid     =  $grid//.bq3
$set $aquiferthick1         =  $grid//.aq1
$set $aquiferthick2         =  $grid//.aq2
$set $aquiferthick3         =  $grid//.aq3
$set $gw_storage_coeff_1    =  $grid//.s01
$set $gw_storage_coeff_2    =  $grid//.s02
$set $gw_storage_coeff_3    =  $grid//.s03
$set $gw_kolmation_1        =  $grid//.gk1
$set $gw_kolmation_2        =  $grid//.gk2
$set $gw_kolmation_3        =  $grid//.gk3
$set $lake_grid             =  $grid//.lak
$set $taucrit_grid          =  $grid//.tau
$set $ThawCoeffPermaFrost   =  $grid//.alpha
$set $T_lower_boundary_grid =  $grid//.tlowbdry
$set $debris_on_glaciers    =  $grid//.debris

# grids for surface hydrology modules
$set $forcingunitsgrid1    =  forc1//$grid//.//$suffix
$set $TStartPhenoGrid1     =  phen1//$grid//.//$suffix
$set $chillingunitsgrid1   =  chill1//$grid//.//$suffix
$set $FStargrid1           =  fstar1//$grid//.//$suffix
$set $forcingunitsgrid2    =  forc2//$grid//.//$suffix
$set $TStartPhenoGrid2     =  phen2//$grid//.//$suffix
$set $chillingunitsgrid2   =  chill2//$grid//.//$suffix
$set $FStargrid2           =  fstar2//$grid//.//$suffix
$set $forcingunitsgrid3    =  forc3//$grid//.//$suffix
$set $TStartPhenoGrid3     =  phen3//$grid//.//$suffix
$set $chillingunitsgrid3   =  chill3//$grid//.//$suffix
$set $FStargrid3           =  fstar3//$grid//.//$suffix
$set $albedo               =  albe//$grid//.//$suffix
$set $soilstoragegrid      =  sb__//$grid//.//$suffix
$set $throughfall          =  qi__//$grid//.//$suffix
$set $snowcover_outflow    =  qsno//$grid//.//$suffix
$set $melt_from_snowcover  =  qsme//$grid//.//$suffix
$set $days_snow            =  sday//$grid//.//$suffix
$set $snow_age             =  sage//$grid//.//$suffix
$set $snow_rate            =  snow//$grid//.//$suffix
$set $rain_rate            =  rain//$grid//.//$suffix
$set $firn_melt            =  qfir//$grid//.//$suffix
$set $ice_melt             =  qice//$grid//.//$suffix
$set $preci_grid           =  prec//$grid//.//$suffix
$set $preci_grid1          =  prec1//$grid//.//$suffix
$set $preci_grid2          =  prec2//$grid//.//$suffix
$set $irrig_grid           =  irri//$grid//.//$suffix
$set $etr2etpgrid          =  er2ep//$grid//.//$suffix
$set $tempegrid            =  temp//$grid//.//$suffix
$set $tempegrid1           =  temp1//$grid//.//$suffix
$set $tempegrid2           =  temp2//$grid//.//$suffix
$set $windgrid             =  wind//$grid//.//$suffix
$set $sunshinegrid         =  ssd_//$grid//.//$suffix
$set $radiationgrid        =  rad_//$grid//.//$suffix
$set $humiditygrid         =  humi//$grid//.//$suffix
$set $vaporgrid            =  vapo//$grid//.//$suffix
$set $ETPgrid              =  etp_//$grid//.//$suffix
$set $EIPgrid              =  eip_//$grid//.//$suffix
$set $ETRgrid              =  etr_//$grid//.//$suffix
$set $EVAPgrid             =  evap//$grid//.//$suffix
$set $EVARgrid             =  evar//$grid//.//$suffix
$set $ETRSgrid             =  etrs//$grid//.//$suffix
$set $SSNOgrid             =  ssno//$grid//.//$suffix
$set $SLIQgrid             =  sliq//$grid//.//$suffix
$set $SSTOgrid             =  ssto//$grid//.//$suffix
$set $sat_def_grid         =  sd__//$grid//.//$suffix
$set $SUZgrid              =  suz_//$grid//.//$suffix
$set $SIFgrid              =  sif_//$grid//.//$suffix
$set $EIgrid               =  ei__//$grid//.//$suffix
$set $SIgrid               =  si__//$grid//.//$suffix
$set $ExpoCorrgrid         =  exco//$grid//.//$suffix
$set $Tcorrgrid            =  tcor//$grid//.//$suffix
$set $Shapegrid            =  shap//$grid//.//$suffix
$set $INFEXgrid            =  infx//$grid//.//$suffix
$set $SATTgrid             =  satt//$grid//.//$suffix
$set $Nagrid               =  na__//$grid//.//$suffix
$set $SSPgrid              =  ssp_//$grid//.//$suffix
$set $Peakgrid             =  peak//$grid//.//$suffix
$set $SBiagrid             =  sbia//$grid//.//$suffix
$set $fcia_grid            =  nfki//$grid//.//$suffix
$set $tavg_grid            =  tavg//$grid//.//$suffix

# now variables for unsaturated zone model
$set $SB_1_grid      =  sb05//$grid//.//$suffix
$set $SB_2_grid      =  sb1_//$grid//.//$suffix
$set $ROOTgrid       =  wurz//$grid//.//$suffix
$set $QDgrid         =  qd__//$grid//.//$suffix
$set $QIgrid         =  qifl//$grid//.//$suffix
$set $GWdepthgrid    =  gwst//$grid//.//$suffix
$set $GWthetagrid    =  gwth//$grid//.//$suffix
$set $GWNgrid        =  gwn_//$grid//.//$suffix
$set $UPRISEgrid     =  uprs//$grid//.//$suffix
$set $PERCOLgrid     =  perc//$grid//.//$suffix
$set $GWLEVELgrid    =  gwlv//$grid//.//$suffix
$set $QDRAINgrid     =  qdrn//$grid//.//$suffix
$set $QBgrid         =  qb__//$grid//.//$suffix
$set $GWINgrid       =  gwin//$grid//.//$suffix
$set $GWEXgrid       =  gwex//$grid//.//$suffix
$set $act_pond_grid  =  pond//$grid//.//$suffix
$set $MACROINFgrid   =  macr//$grid//.//$suffix
$set $SUBSTEPSgrid   =  step//$grid//.//$suffix

$set $SnowFreeDaysGrid  = sfre//$grid//.//$suffix
$set $SnowCoverDaysGrid = scov//$grid//.//$suffix
$set $ThawDepthGrid     = thdp//$grid//.//$suffix
$set $ThawDepthGridTMod = thaw//$grid//.//$suffix

# variables for groundwater modeling
$set $flowx1grid     =  gwx1//$grid//.//$suffix
$set $flowx2grid     =  gwx2//$grid//.//$suffix
$set $flowx3grid     =  gwx3//$grid//.//$suffix
$set $flowy1grid     =  gwy1//$grid//.//$suffix
$set $flowy2grid     =  gwy2//$grid//.//$suffix
$set $flowy3grid     =  gwy3//$grid//.//$suffix
$set $head1grid      =  gwh1//$grid//.//$suffix
$set $head2grid      =  gwh2//$grid//.//$suffix
$set $head3grid      =  gwh3//$grid//.//$suffix
$set $GWbalance1grid =  gwbalance1//$grid//.//$suffix
$set $GWbalance2grid =  gwbalance2//$grid//.//$suffix
$set $GWbalance3grid =  gwbalance3//$grid//.//$suffix

# result grids for surface routing model
$set $surfspeed_grid        =  sfcv//$grid//.//$suffix
$set $surfflux_grid         =  sflx//$grid//.//$suffix

# some new stacks and grids for the dynamic glacier model
$set $firn_WE_stack           = glfirn//$stack//.//$suffix
$set $GlacierMassBalance      = glmb//grid//.//$suffix
$set $OldGlacierMassBalance   = glmb_old//grid//.//$suffix
$set $glacierizedCells_grid   = glc_//$grid//.//$suffix
$set $glacier_codes_grid      = glid//$grid//.//$suffix

# result-stacks for Unsatzonmodel
$set $Thetastack              = teth//$stack//.//$suffix
$set $hydraulic_heads_stack   = hhyd//$stack//.//$suffix
$set $geodetic_altitude_stack = hgeo//$stack//.//$suffix
$set $flowstack               = qu__//$stack//.//$suffix
$set $concstack               = conc//$stack//.//$suffix
# result-stacks for temperatures in Unsatzonmodel
$set $Temperaturestack	      = tsoil//stack//.//$suffix

# parameters for interpolation of meteorological input data
$set $SzenUse        =  0
$set $IDWmaxdist     =  200000
$set $IDWweight      =  2
$set $Anisoslope     =  0.0
$set $Anisotropie    =  1.0


# explanation of writegrid and outputcode some lines below
$set $Writegrid      =  3
$set $Writestack     =  3

$set $once_per_interval  =  5001
$set $avrg_per_24Invs    =  2001
$set $sum_per_24Invs     =  4001
$set $routing_code       =  5001


#  Writegrid : max. 4 digits (nnnn)
#
#     only if writegrid >= 1000: 1. digit (1nnn, or 2nnn)
#     0 = no vegetation period based grid is written
#     1 = sum grid is written for vegetation period (summing up each value as long as this cells vegetation period is active)
#     2 = average value grid is written for vegetation period (summing up each value as long as this cells vegetation period is active)
#     only if writegrid >= 100: 2. digit (n1nn, or n2nn or n3nn or 1nn..3nn  -> leading digits may be omitted))
#      0 = no minimum or maximum grid is written
#      1 = minimum grid is written (minimum value for each of the grid cells over the entire model period)          
#      2 = maximum grid is written (maximum value for each of the grid cells over the entire model period)          
#      3 = both grids are written (minimum and maximum value for each of the grid cells over the entire model period)          
#     only if Writegrid >=  10: 3rd digit: sums or means (1n ... 8n or n1n..n8n or nn1n..nn8n  -> leading digits may be omitted))
#       0 = no sum grid will be written
#       1 = one sum grid will be written at the end of the model run
#       2 = one sum grid per model year
#       3 = one sum grid per model month
#       4 = one sum grid per day (only, if timestep < 1 day)
#       5 = one mean value grid at the end of the model run
#       6 = one mean value grid per model year
#       7 = one mean value grid per month
#       8 = one mean value grid per day
#     last digit (nnn1 .. nnn5 or nn1..nn5 or n1..n5 or 1..5 -> leading digits may be omitted) (for actual values, not for Sums or means)
#        1 = (over)write each timestep into the same grid (for security in case of model crashs)
#        2 = write grids each timestep to new files, the name is build from the first 4 letters
#            of the regular grid name and then from the number of month, day and hour (hoer as file extension).
#            example: tempm500.grd will become prec0114.07 for 14.January, 7:00.
#        3 = only the last grid of the model run will be stored
#        4 = the grid from the last hour of each day (24:00) will be stored (for each day the same file will be overwritten)
#        5 = like 4, but each day a new grid file is created (like for code 2)
#        6 = actual grid at the end of each month
#        7 = actual grid at the end of each year
#        8 = write immediately after reading the grid from file and filling missing values. This is used for an automated filling of missing values only. Should not be used productive
#
# outputcode (for statistic files for zones or subcatchments)
#
# the Codes behind the names of the statistic files have the meaning of:
# <1000   : no output
# 1<nnn>  : spatial mean values for the entire basin, averaged in time over <nnn> intervals (timesteps)
# 2<nnn>  : spatial mean values for all zones (subbasin) and for the entire basin, averaged in time over <nnn> intervals (timesteps)
# 3<nnn>  : spatial means for the entire basin, added up in time over <nnn> intervals (timesteps)
# 4<nnn>  : spatial means for all zones (subbasin) and for the entire basin, added up in time over <nnn> intervals (timesteps)
# 5<nnn>  : spatial means for the entire basin and for those subbasins which are specified in the output-list, averaged in time over <nnn> intervals
# 6<nnn>  : spatial means for the entire basin and for those subbasins which are specified in the output-list, added up in time over <nnn> intervals
#
# example:
#  2001 = per timestep for all subcatchments (and for the entire basin) one (spatially averaged) value,
#  2004 = each 4 time steps one averaged value over the last 4 time steps for all subcatchments and for the entire basin,
#  4024 = Sums of the mean subcatchment/entire basin values of the timesteps over 24 timesteps (e.g. daily rain sums for subcatchments),
#  3120 = averaged values (over 120 time steps!) only for the entire basin (spatially averaged)
#  5012 = averaged values (over 12 timesteps) as spatial averages for the entire basin and for each of the subbasins specified in the output-list

[output_list] # FR
1             # number of subbasins which are scheduled for output (is only of interest, if the code for the statistic files are >5000)
10

[output_interval]
30             # increment of time steps until an output to the screen is done (24 = each day one output, if time steo = 1h)
1             # warning level for interpolation (no station within search radius)
0             # unit of routed discharge (0=mm/timestep, 1=m3/s)
0              # minutes from the hour-entry in the input data files until the end 
# of the time step is reached 0 if the end of time step is given like "84 01 01 01", 
# but it should be $time if the begin is given like in "84 01 01 00"
WriteDoubleGrids = 0
WriteAsciiGrids = 0 								# 0 if grids should be written in WaSiM native format, 1 if in ESRI ASCII format
InitialStateDirectory = $InitialStateDirectory 		# if using this parameter, all state grids  as well as the storage_richards.ftz file will be expected in that directory for reading
DefaultOutputDirectory = $DefaultOutputDirectory 	# this is the default output directory, all output is written to unless the given filename contains an absolute path 
# there are some exceptions, though: for external coupling no default output path is used
# relative pathnames may be used as well.
# for compatibility reasins with older control files and WaSiM versions, both directories will only be used if the given filename has no absolute path,
# so in order to use the new features, all $outpath uses should be reviewed and removed if necessary (or the variable should be set to an empty string)

[coordinates]
51.4           # geogr. latitude (center of the basin -> for radiation calculations)
9.98           # geogr. longitude (center of the basin)
15.0           # meridian according to the official time (middle europe: 15)(east: 0 ... +180 degree, west: 0 ... -180 (or 360 ... 180)
1              # time shift of Meteo-data-time with respect to the true local time (mean sun time)
# e.g.: if meteo-data are stored in UTC-time and the time meridian is 15 east (central europe),
# than the local time is 1 hour later than the time in the meteo-data-file, so 1 hour has to be added to the time from this file
# this is important for calculation of sunshine duration and radiation

[region_transition_distance]
10000 # in m

[soil_surface_groundwater_substeps] 
12 # number of sub time steps for the module group surface routing, unsaturated zone model and groundwater model (and accumulation of real evapotranspiration)
# Values to start with are 1 (default), 2
# (half of the common time step), 3 etc. Please be carefull not to set too high values here since the model
# performance will go down dramatically, since unsatzonmodel and surface routing are called each
# time!

[elevation_model]
$inpath_grid//$elevation_model    # grid with the digital elevation data

[zone_grid]
$inpath_grid//$zone_grid          # grid with Zone codes

$set $lai_grid = lai_//$grid//.//$suffix
$set $z0_grid = z0_//$grid//.//$suffix
$set $root_grid = root_//$grid//.//$suffix
$set $rse_grid = rse_//$grid//.//$suffix
$set $rsi_grid = rsi_//$grid//.//$suffix
$set $rsc_grid = rsc_//$grid//.//$suffix
$set $albedo_grid = albedo_//$grid//.//$suffix
$set $vcf_grid = vcf_//$grid//.//$suffix

$set $lai_stat = lai_//$grid//.//$code//$year 
$set $z0_stat = z0_//$grid//.//$code//$year 
$set $root_stat = root_//$grid//.//$code//$year 
$set $rse_stat = rse_//$grid//.//$code//$year 
$set $rsi_stat = rsi_//$grid//.//$code//$year 
$set $rsc_stat = rsc_//$grid//.//$code//$year 
$set $albedo_stat = albedo_//$grid//.//$code//$year 
$set $vcf_stat = vcf_//$grid//.//$code//$year 


# there is a simple possibility starting with WaSiM 8.10.03 to do the nearest neighbor filling permanently: simply set the writecode for the standardgrid to 8 and the grid 
# will be writen to the default output directory with it's original name but an additional suffix "filled". Once thsi grid is written, it can be converted to binary optionally and 
# used as input grid (without fillcode = 1 then).

[standard_grids]
5                           	# number of standard grids
$inpath_grid//$albedo_grid     		albedo  		fillcode = 0  defaultValue = 0.2 writecode = 3 readcode = 0 outname = $outpath//$albedo_grid statfile = $outpath//$albedo_stat statcode = $once_per_interval 
$inpath_grid//$land_use_grid    	landuse                   fillcode = 1 	# writecode = 8 readcode = 1 outname = $outpath//$land_use_grid # grid with land use data (will be written out after reading in for getting gthe filles values)
$inpath_grid//$subcatchments    	zonegrid_soilmodel        1    			# zone grid for the runoff generation model (and unstaurated zone model)
$inpath_grid//$soil_types       	soil_types                fillcode = 1 	# writecode = 8 readcode = 1 outname = $outpath//$soil_types     		# soil types as codes for the soil table
$inpath_grid//$T_lower_boundary_grid	T_Lower_Boundary_Condition fillcode = 0   defaultValue = 10  writecode = 8 readcode = 0 


# variable grids are used by more than one module or can be changed (like albedo and soil storage)
$set $SurfStorSiltingUp    =  sfstsu//$grid//.//$suffix
$set $pondgridtopmodel     =  pond_top//$grid//.//$suffix
$set $VegetationStart      =  vegstart//$grid//.//$suffix
$set $VegetationStop       =  vegstop//$grid//.//$suffix
$set $VegetationDuration   =  vegduration//$grid//.//$suffix

[variable_grids]
4                                                      	# Number of variable grids to read
$outpath//$forcingunitsgrid1      SumOfForcingUnits1        0 -1
$Writegrid                                          
$DPreadgrids                                               
$outpath//$TStartPhenoGrid1       Pheno_start1                0 -1
$Writegrid                                           
$DPreadgrids                        
$outpath//$chillingunitsgrid1     SumOfChillingUnits1         0 -1
$Writegrid                                           
$DPreadgrids                                          
$outpath//$FStargrid1            FStar_ForcingThreshold1          0 -1
$Writegrid                                            
$DPreadgrids

[model_time]
$starthour            #  start hour
$startday             #  start day
$startmonth           #  start month
$startyear            #  start year
$endhour              #  end hour
$endday               #  end day
$endmonth             #  end month
$endyear              #  end year

[meteo_data_count]
5

[meteo_names]
temperature
wind_speed
precipitation
global_radiation
air_humidity

# methods: 
# 1  = idw 
# 2  = regress 
# 3  = idw+regress 
# 4  = thiessen 
# 5  = bilinear 
# 6  = bilinear gradients and residuals linarly combined, 
# 7  = bicubic spline, 
# 8  = bicubic splines of gradients and residuals linearly combined, 
# 9  = read grids according to the name in a grid list file, 
# 10 = regression from Stationdata instead from outputfile of regr.exe (similar to method 1, except that no station selection may be applied))
# 11 = regression and IDW from station data (equivalent to method 3, except that no station selection may be applied)
# 12 = Thiessen with given lapse rate (as single next line parameter or with multiple parameters lower lapse rate, upper limit, upper lapse rate, type (P-type or T-type , important for continuous or discontinuous data modelling)
 

[temperature]
4 									                        # methods, see comments above
$inpath_meteo//Tmean.tat AdditionalColumns=0	   			# file name with station data (if method = 1, 3 or 4, else ignored)
# $inpath_meteo//.out  										# file name with regression data (if method = 2 or 3)
820 1400 200 1 300 											# lower inversion [m asl], upper inversion [m asl], tolerance [m], overlap [0/1 for true/false], clusterlimit [m] 
$outpath//$tempegrid          								# name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
5//$Writegrid	                    						# 0, if no grid-output is needed, else one of the codes described above
1.0                           								# correction faktor for results
$outpath//temp//$grid//.//$code//$year $once_per_interval  	# file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                           								# error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    								# weighting of the reciprocal distance for IDW
0.5 	                         							# for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   								# max. distance of stations to the actual interpolation cell
$Anisoslope                   								# slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  								#  ratio of the short to the long axis of the anisotropy-ellipsis
-40                           								#  lower limit of interpolation results
-40                           								#  replace value for results below the lower limit
40                            								#  upper limit for interpolation results
40                            								#  replace value for results with larger values than the upper limit
$SzenUse                      								#  1=use scenario data for correction, 0=dont use scenarios
1                             								#  1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             								#  number of scenario cells

[wind_speed]
4 			                             					# method: 1=idw 2=regress 3=idw+regress 4=thiessen 5=bilinear 6=bilinear gradients and residuals linarly combined
$inpath_meteo//Windmean.tat AdditionalColumns=0  			# file name with station data (if method = 1, 3 or 4, else ignored)
# $inpath_meteo//.out  										# file name with regression data (if method = 2 or 3)
820 1400 200 1 300 											# lower inversion [m asl], upper inversion [m asl], tolerance [m], overlap [0/1 for true/false], clusterlimit [m] 
$outpath//$windgrid           								# name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
5//$Writegrid                    							# 0, if no grid-output is needed, else one of the codes described above
1.0                           								# correction faktor for results
$outpath//wind//$grid//.//$code//$year $once_per_interval  	# file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                           								# error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    								# weighting of the reciprocal distance for IDW
0.50                           								# for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   								# max. distance of stations to the actual interpolation cell
$Anisoslope                   								# slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  								#  ratio of the short to the long axis of the anisotropy-ellipsis
0                             								# lower limit of interpolation results
0                             								# replace value for results below the lower limit
90                            								# upper limit for interpolation results
90                            								# replace value for results with larger values than the upper limit
$SzenUse                      								# 1=use scenario data for correction, 0=dont use scenarios
3                             								# 1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             								# number of scenario cells


[precipitation]
4                              								# method: 1=idw 2=regress 3=idw+regress 4=thiessen 5=bilinear 6=bilinear gradients and residuals linarly combined
$inpath_meteo//Niedsum.tat AdditionalColumns=0   			# file name with station data (if method = 1, 3 or 4, else ignored)
# $inpath_meteo//.out  										# file name with regression data (if method = 2 or 3)
700 1400 400 1 300 											# lower inversion [m asl], upper inversion [m asl], tolerance [m], overlap [0/1 for true/false], clusterlimit [m] 
$outpath//$preci_grid       	 							# name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
1//$Writegrid	                    						# 0, if no grid-output is needed, else one of the codes described above
1.0                           								# correction faktor for results
$outpath//prec//$grid//.//$code//$year $once_per_interval  	# file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                           								# error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    								# weighting of the reciprocal distance for IDW
0.5                          								# for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   								# max. distance of stations to the actual interpolation cell
$Anisoslope                   								#  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  								#  ratio of the short to the long axis of the anisotropy-ellipsis
0.1			      											# lower limit of interpolation results
0                             								# replace value for results below the lower limit
900                           								# upper limit for interpolation results
900                           								# replace value for results with larger values than the upper limit
$SzenUse                      								# 1=use scenario data for correction, 0=dont use scenarios
2                             								# 1=add scenarios, 2=multiply scenarios, 3=percentual change
1 	                      									# number of scenario cells

[global_radiation]
4 # FR 1                             						# method: 1=idw 2=regress 3=idw+regress 4=thiessen 5=bilinear 6=bilinear gradients and residuals linarly combined
$inpath_meteo//Radmean.tat AdditionalColumns=0  			# file name with station data (if method = 1, 3 or 4, else ignored)
# $inpath_meteo//.out  										# file name with regression data (if method = 2 or 3)
820 1400 200 1 300 											# lower inversion [m asl], upper inversion [m asl], tolerance [m], overlap [0/1 for true/false], clusterlimit [m] 
$outpath//$radiationgrid      								# name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
5//$Writegrid                    							# 0, if no grid-output is needed, else one of the codes described above
1.0                           								# correction faktor for results
$outpath//rad_//$grid//.//$code//$year $once_per_interval  	# file name for the statistic output (statially averaged values per time step and subcatchment...)
19998                          								# error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    								# weighting of the reciprocal distance for IDW
0.5                           								# for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   								# max. distance of stations to the actual interpolation cell
$Anisoslope                   								#  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  								#  ratio of the short to the long axis of the anisotropy-ellipsis
0                             								# lower limit of interpolation results
0                             								# replace value for results below the lower limit
19999                          								# upper limit for interpolation results
16500                          								# replace value for results with larger values than the upper limit
$SzenUse                      								# 1=use scenario data for correction, 0=dont use scenarios
1                             								# 1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             								# number of scenario cells

[air_humidity]
4 				                             				# method: 1=idw 2=regress 3=idw+regress 4=thiessen 5=bilinear 6=bilinear gradients and residuals linarly combined
$inpath_meteo//Luftfeuchte.tat AdditionalColumns=0  		# file name with station data (if method = 1, 3 or 4, else ignored)
# $inpath_meteo//.out  										# file name with regression data (if method = 2 or 3)
900 1500 300 1 150 											# lower inversion [m asl], upper inversion [m asl], tolerance [m], overlap [0/1 for true/false], clusterlimit [m] 
$outpath//$humiditygrid       								# name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
5//$Writegrid                    							# 0, if no grid-output is needed, else one of the codes described above
1.0                          								# correction faktor for results
$outpath//humi//$grid//.//$code//$year $once_per_interval 	# file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                          								# error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    								# weighting of the reciprocal distance for IDW
0.5 		                          						# for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   								# max. distance of stations to the actual interpolation cell
$Anisoslope                   								#  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  								#  ratio of the short to the long axis of the anisotropy-ellipsis
0.01                          								# lower limit of interpolation results
0.01                          								# replace value for results below the lower limit
1.0                           								# upper limit for interpolation results
1.0                           								# replace value for results with larger values than the upper limit
$SzenUse                      								# 1=use scenario data for correction, 0=dont use scenarios
3                             								# 1=add scenarios, 2=multiply scenarios, 3=percentual change
1                             								# number of scenario cells

# ----------  parameter for model components  -----------------

[RegionalSuperposition]
0					# 0=ignore this module, 1 = run the module

[precipitation_correction]
1                     # 0=ignore this module, 1 = run the module
0.0                   # Snow-rain-temperature
1.02                  # liquid:   b in:  y = p(ax + b)
0.01                  # liquid:   a in:  y = p(ax + b) = 1% more per m/s + 0.5% constant
1.15                  # Snow:     b in:  y = p(ax + b)
0.15                  # Snow:     a in:  y = p(ax + b) = 15% more per m/s + 45% constant

# corretion factors for direct radiation are calculated
# if the cell is in the shadow of another cell, or if a cell is not in the sun (slope angle!)
# then the factor is 0.
# control_parameter: 1 = radiation correction WITH  shadow WITHOUT temperature correction
#                    2 = radiation correction WITH  shadow WITH  temperature correction
#                    3 = radiation correction WITHOUT shadow WITHOUT temperature correction,
#                    4 = radiation correction WITHOUT shadow WITH  Temperatur

[radiation_correction]
1                    					# 0=ignore this module, 1 = run the module
$time                					# duration of a time step in minutes
2                    					# control parameter for radiation correction (see above)
$outpath//$Tcorrgrid 					# name of the grids with the corrected temperatures
5//$Writegrid           				# Writegrid for corrected temperatures
20                                       # factor x for temperature correction x * (-1.6 .... +1.6)
$outpath//$ExpoCorrgrid   				# name of the grids with the correction factors for the direct radiation
5//$Writegrid           				# Writegrid
$outpath//$Shapegrid 					# name of the grids for codes 1 for theor. shadow, 0 for theor. no shadow (day; assumed: SSD=1.0)
5//$Writegrid           				# Writegrid
1                    					# interval counter, after reaching this value, a new correction is calculated (3=all 3 hours a.s.o.)
1                    					# Spitting of the interval, usefull for time step=24 hours (then: split=24, -> each hour one correction calculation)

[evapotranspiration]
1                        				# 0=ignore this module, 1 = run the module
$time                    				# duration of a time step in minutes
1                        				# Method: 1=Penman-Monteith, 2=Hamon (only daily), 3=Wendling (only daily) 4= Haude (only daily)
0.2  0.2  0.35  0.4  0.4 0.4 0.4 0.4 0.35 0.2 0.2 0.2  		# PEC correction factor for HAMON-evapotranspiration
0.20 0.20 0.21 0.29 0.29 0.28 0.26 0.25 0.22 0.22 0.20 0.20 # fh (only for method 4: Haude) monthly values (Jan ... Dec) (here: for Grass)
0.5                      									# fk -> factor for Wendling-evapotranspiration (only for Method = 3)
$outpath//$ETPgrid       									# result grid for pot. evapotranspiration in mm/dt
$Writegrid            										# 0, if no grid-output is needed, else one of the codes described above
$outpath//etp_//$grid//.//$code//$year $once_per_interval 	# statisticfile for Teilgebiete of pot. evapo-Transpiration
$outpath//$ETRgrid       									# result grid for real evapotranspiration in mm/dt
$Writegrid            										# 0, if no grid-output is needed, else one of the codes described above
$outpath//etr_//$grid//.//$code//$year $once_per_interval 	# statistic for subcatchments (zones) of the real evapotranspiration
$outpath//$EVAPgrid      									# result grid for real evapotranspiration in mm/dt
$Writegrid            										# 0, if no grid-output is needed, else one of the codes described above
$outpath//evap//$grid//.//$code//$year $once_per_interval 	# statistic for subcatchments (zones) of the potential evaporation
$outpath//$EVARgrid      									# result grid for real evapotranspiration in mm/dt
$Writegrid            										# 0, if no grid-output is needed, else one of the codes described above
$outpath//evar//$grid//.//$code//$year $once_per_interval 	# statistic for subcatchments (zones) of the real evaporation
$outpath//$ETRSgrid	 										# result grid for real snow evapotranspiration in mm/dt
$Writegrid        	 										# 0, if no grid-output is needed, else one of the codes described above
$outpath//etrs//$grid//.//$code//$year $once_per_interval 	# statistic for subcatchments (zones) of the real snow evaporation
$outpath//$EIPgrid       									# result grid for pot. interception evaporation in mm/dt
$Writegrid               									# 0, if no grid-output is needed, else one of the codes described above
$outpath//eip_//$grid//.//$code//$year $once_per_interval 	# statisticfile for zones of pot. interception evaporation
$outpath//rgex//$grid//.//$code//$year $once_per_interval 	# statistic for subcatchments (zones) of the corrected radiation
+0.23   +1.77    -2.28    +1.28    							# coefficients c for Polynom of order 3 RG = c1 + c2*SSD + c3*SSD^2 + c4*SSD^3
+0.072  -0.808   +2.112   -0.239   							# coefficients x for Polynom of order 3 SSD = x1 + x2*RG + x3*RG^2 + x4*RG^3
0.88 0.05                          							# Extinktion coefficient for RG-modeling (Phi and dPhi) (summer phi = phi-dphi, winter phi=phi+dphi)
1654.0                             							# recession constant (e-function for recession of the daily temperature amplitude with altitude [m]
3.3  4.4  6.1  7.9  9.4  10.0  9.9  9.0  7.8  6.0  4.2  3.2 # monthly values of the max. daily T-amplitudes (for 0 m.a.s.l)
0.62  0.1                          							# part of the temperature amplitude (dt), that is added to the mean day-temperature
																# (followed by the range of changing within a year ddt) to get the mean temperature of light day
																# in the night: mean night temperature is mean day temperature minus (1-dt)*(temp. amplitude)

[snow_model]
1                    # 0=ignore this module, 1 = run the module
$time                # duration of a time step in minutes
1                    # method 1=T-index, 2=t-u-index, 3=Anderson comb., 4=extended com.
1.0                  # transient zone for rain-snow (T0R +- this range)
0.0                  # T0R    temperature limit for rain (Grad Celsius)
0.0                  # T0     temperature limit snow melt
0.05                 # CWH    storage capacity of the snow for water (relative part)
1.0                  # CRFR   coefficient for refreezing
2.5                  # C0     degree-day-factor mm/d/C
0.8                  # C1     degree-day-factor without wind consideration  mm/(d*C)
0.17                 # C2     degree-day-factor considering wind mm/(d*C*m/s)
0.07                 # z0     roughness length cm for energy bilance methods (not used)
1.0                  # RMFMIN minimum radiation melt factor      mm/d/C comb. method
2.5                  # RMFMAX maximum radiation melt factor      mm/d/C comb. method
0.45                 # Albedo for snow (Min)
0.90                 # Albedo for snow (Max)
$outpath//$rain_rate         								# rain rate
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//rain//$grid//.//$code//$year $once_per_interval 	# rain rate
$outpath//$snow_rate         								# snow rate
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//snow//$grid//.//$code//$year $once_per_interval 	# snow rate
$outpath//$days_snow         								# days with snow (SWE > 5mm)
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//sday//$grid//.//$code//$year $once_per_interval 	# days with snow (SWE > 5mm)
$outpath//$snow_age          								# snow age (days without new snow)
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//sage//$grid//.//$code//$year $once_per_interval 	# days since last snowfall
$outpath//albe//$grid//.//$code//$year $once_per_interval 	# Albedo
$outpath//$snowcover_outflow 								# discharge from snow, input (precipitation) for following modules
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//qsch//$grid//.//$code//$year $once_per_interval 	# melt  (or rain, if there is no snow cover) in mm/dt
$outpath//$melt_from_snowcover 								# discharge from snow, input (precipitation) for following modules
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//qsme//$grid//.//$code//$year $once_per_interval 	# melt flow in mm/dt
$outpath//$SSNOgrid          								# name of the grids with the snow storage solid in mm
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//$SLIQgrid          								# name of the grids with the snow storage liquid in mm
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$outpath//ssto//$grid//.//$code//$year $once_per_interval 	# total snow storage, in mm, (liquid and solid fraction)
$outpath//$SSTOgrid          								# name of the grids with the total snow storage solid AND liquid in mm
$Writegrid                   								# 0, if no grid-output is needed, else one of the codes described above
$readgrids                   								# 1=read snow storage solid, liquid grids from disk, 0=generate new grids

[ice_firn]
0   		# 0=ignore this module, method for glacier melt: 1=classical t-index, 2=t-index with correction by radiation, 11 = dynamic glacier model with classical t-index, 12 = dynamic glacier model with radiation correction

[permafrost]
0			# 0=ignore this module, method: 1=simple Alpha*sqrt(snow-free-days) approach to estimate thawdepth

[interception_model]
1                             				# 0=ignore this module, 1 = run the module
$time                        				# duration of a time step in minutes
2											# method: 1 = use ETP for calculating EI; 2 = use EIP for calculating EI (only effective for method 1 in evapotranspiration model -> for other methods, ETP = EIP)
$outpath//$throughfall       				# result grid :  = outflow from the interception storage
$Writegrid                   				# 0, if no grid-output is needed, else one of the codes described above
$outpath//qi__//$grid//.//$code//$year $once_per_interval 	# statistic file interception storage outflow
$outpath//$EIgrid            				# Interzeption evaporation, grid
$Writegrid                					# 0, if no grid-output is needed, else one of the codes described above
$outpath//ei__//$grid//.//$code//$year $once_per_interval 	# zonal statistic
$outpath//$SIgrid            				# storage content of the interception storage
$Writegrid                					# 0, if no grid-output is needed, else one of the codes described above
$outpath//si__//$grid//.//$code//$year $once_per_interval 	# zonal statistic For interception storage content
0.35                         				# layer thickness of the waters on the leaves (multiplied with LAI -> storage capacity)
$readgrids                   				# 1=read grids from disk, else generate internal

[infiltration_model] 
1							# 0=ignore this module, 1 = run the module
$time          				# duration of a time step in minutes
$outpath//$INFEXgrid     	# grid with infiltration excess in mm (surface runoff)
$Writegrid                	# for surface discharge (fraction 1)
$outpath//infx//$grid//.//$code//$year $once_per_interval # statistic file for the infiltration excess
$outpath//$SATTgrid          # grid with code 1=saturation at interval start, 0 =no saturation.
$Writegrid                   # Writegrid for saturation code grids
0.1                          # fraction of reinfitrating water (of the infiltration excess)

$set $SDISPgrid            =  sdis//$grid//.//$suffix
$set $RPAUSgrid            =  paus//$grid//.//$suffix
$set $EKIN_grid            =  ekin//$grid//.//$suffix
$set $TSBB_grid            =  tsbb//$grid//.//$suffix
$set $QDSU_grid            =  qdsu//$grid//.//$suffix

[SiltingUpModel] # FR
0                            # 0=ignore this module, 1 = run the module

[SurfaceRoutingModel] # FR
0                            # 0=ignore this module, 1 = run the module

[lake_model] # FR
0                            # 0=ignore this module, 1 = run the module

[unsatzon_model]
1	 	# 0=ignore this module, 1 = run the module
$time	# duration of a time step in minutes
3		# method, 1=simple method (will not work anymore from version 7.x), 2 = FDM-Method 3 = FDM-Method with dynamic time step down to 1 secound
0  		# controlling interaction with surface water: 0 = no interaction, 1 = exfiltration possible 2 = infiltration and exfiltration possible
0  		# controlling surface storage in ponds:       0 = no ponds,       1 = using ponds for surface storage (pond depth as standard grid needed -> height of dams oround fields)
0  		# controlling artificial drainage:            0 = no artificial drainage 1 = using drainage (drainage depth and horizontal pipe distances as standard grids needed!)
0  		# controlling clay layer:                     0 = no clay layer,  1 = assuming a clay layer in a depth, specified within a clay-grid (declared as a standard grid)
5e-8    # permeability of the clay layer (is used for the clay layer only)
2   	# parameter for the initialization of the gw_level (range between 1..levels (standard: 4)) 4 means: the upper 1/4th of the layers is unsaturated
$outpath//qdra//$grid//.//$code//$year $once_per_interval 	# results drainage discharge in mm per zone
$outpath//gwst//$grid//.//$code//$year $once_per_interval 	# results groundwater depth
$outpath//gwn_//$grid//.//$code//$year $once_per_interval 	# results mean groundwater recharge per zone
$outpath//sb05//$grid//.//$code//$year $once_per_interval 	# results rel. soil moisture within the root zone per zone
$outpath//sb1_//$grid//.//$code//$year $once_per_interval 	# results rel. soil moisture within the unsat. zone (0m..GW table) per zone
$outpath//wurz//$grid//.//$code//$year $once_per_interval 	# results statistic of the root depth per zone
$outpath//infx//$grid//.//$code//$year $once_per_interval 	# results statistic of the infiltration excess
$outpath//pond//$grid//.//$code//$year $once_per_interval 	# results statistic of the ponding water storage content
$outpath//qdir//$grid//.//$code//$year $once_per_interval 	# results statistic of the direct discharge
$outpath//qifl//$grid//.//$code//$year $once_per_interval 	# results statistic of the interflow
$outpath//qbas//$grid//.//$code//$year $once_per_interval 	# results statistic of the baseflow
$outpath//qges//$grid//.//$code//$year $once_per_interval 	# results statistic of the total discharge
$outpath//gwin//$grid//.//$code//$year $once_per_interval 	# statistic of the infiltration from surface water into groundwater (from rivers and lakes)
$outpath//gwex//$grid//.//$code//$year $once_per_interval 	# statistic of the exfiltration from groundwater into surface water (into rivers and lakes)
$outpath//macr//$grid//.//$code//$year $once_per_interval 	# statistic of infiltration into macropores
$outpath//qinf//$grid//.//$code//$year $once_per_interval 	# statistic of total infiltration into the first soil layer
$outpath//$SB_1_grid         		# grid with actual soil water content for the root zone
$Writegrid                			# Writecode for this grid
$outpath//$SB_2_grid         		# grid with actual soil water content for the entire unsaturated zone
$Writegrid                			# Writecode for this grid
$outpath//$ROOTgrid          		# grid with root depth 
$Writegrid                   		# Writecode for this grid
$outpath//$Thetastack        		# stack, actual soil water content for all soil levels
$Writegrid                  		# Writecode for this stack
$outpath//$hydraulic_heads_stack   	# stack, contaiing hydraulic heads
$Writestack                  		# Writecode for this stack
$outpath//$geodetic_altitude_stack  # stack, containig geodaetic altitudes of the soil levels (lower boudaries)
$Writestack                  		# Writecode for this stack
$outpath//$flowstack         		# stack, containing the outflows from the soil levels
$Writestack                  		# Writecode for this stack
$outpath//$GWdepthgrid       		# grid with groudwaterdepth
$Writegrid                   		# Writecode for this grid
$outpath//$GWthetagrid       		# grid with theta in GWLEVEL
$Writegrid                   		# Writecode for this grid
$outpath//$GWNgrid           		# grid with groundwater recharge
$Writegrid                   		# Writecode for this grid
$outpath//$GWLEVELgrid       		# grid with level index of groundwater surface (Index der Schicht)
$Writegrid                   		# Writecode for this grid
$outpath//$QDRAINgrid        		# grid with the drainage flows
$Writegrid                   		# Writecode for this grid
$outpath//$SATTgrid          		# grid with code 1=saturation at interval start, 0 no sat.
$Writegrid                   		# Writecode for this grid
$outpath//$INFEXgrid         		# grid with infiltration excess in mm (surface discharge)
$Writegrid                   		# Writecode for this grid
$outpath//$QDgrid            		# grid with direct discharge
1//$Writegrid                   	# Writecode for this grid
$outpath//$QIgrid            		# grid with Interflow
1//$Writegrid                   	# Writecode for this grid
$outpath//$QBgrid            		# grid with baseflow
1//$Writegrid                   	# Writecode for this grid
$outpath//$GWINgrid         		# grid with infiltration from rivers into the soil (groundwater)
1//$Writegrid                   	# Writecode for this grid
$outpath//$GWEXgrid          		# grid with exfiltration (baseflow) from groundwater (is only generated, if groundwater module is active, else baseflow is in QBgrid)
1//$Writegrid                   	# Writecode for this grid
$outpath//$act_pond_grid     		# grid with content of ponding storge
$Writegrid                   		# Writecode for this grid
$outpath//$UPRISEgrid        		# grid with amount of capillary uprise (mm)
1//$Writegrid                   	# Writecode for this grid
$outpath//$PERCOLgrid        		# grid with amount of percolation (mm)
1//$Writegrid                   	# writegrid for this grid
$outpath//$MACROINFgrid      		# grid with amount of infiltration into macropores (mm)
1//$Writegrid                   	# Writecode for this grid
$outpath//$irrig_grid        		# grid with irrigation amount (will be written when irrigation is used, only)
$Writegrid                  		# writegrid for this grid (however: will be written when irrigation is used, only)
2 2 				 				# coordinates of control plot, all theta and qu-values are written to files (qu.dat, theta.dat in the directory, from which the model is started)
$outpath//qbot//$grid//.//$code//$year  	# name of a file containing the flows between the layers of the control point
$outpath//thet//$grid//.//$code//$year  	# name of a file containing the soil moisture as theta values of the layers of the control point
$outpath//hhyd//$grid//.//$code//$year  	# name of a file containing the hydraulic head of the layers of the control point
$outpath//otherdata//$grid//.//$code//$year # name of a file containing some other water balance data of the control point (non layer data)
$outpath//etrd//$grid//.//$code//$year  	# name of a file containing the withdrawal of soil water for each layer for the control point (due to transpiration)
$outpath//intd//$grid//.//$code//$year  	# name of a file containing the interflow for the soil layers of the control point
#Port	Branson	Sion/R	Brig/R	Visp/V	Marti/D	LeChab	Reck/R	Blatt/M	Aigle	Blatt/L	Brig/S	Gletsch	ZEG	ZEG/L	Ltsch	Lake	# subbasins
10 #  codes of the subbasins (in the subbasin grid) 
$kd1	# kd
$ki1	# ki
$dr1	# dr
4 		# k in qb = Q0 * exp(-k/z) with z = depth to groundwater
8		# Q0 in the above formula
$sdf1	# fraction of surface runoff on snow melt
$readgrids               				# meanings are extended now! read the follwing comments
$outpath//storage_richards.ftz			# if readgrids = 1, then this file contains the contents of the flow travel time zones for interflow and surface flow and for the tracers
36 	 									# minimum dynamic time step in secounds. the smaller this number, the longer the model runs but the results will be more accurate due to a maintained Courant condition
$outpath//step//$grid//.//$code//$year $once_per_interval	# results statistic of the number of substeps 
$outpath//$SUBSTEPSgrid     			# grid with number of substeps --> a good idea is to use writecode 5x (e.g. 53) to get the average number of substeps per cell for the model run
$Writegrid	               				# for substeps, the areal distribution is of interest for the annual average value. This is code 6 as first digit in 2-digit codes. Or use 5 for the entire model run


[heat_transfer]
0                        				# 0 = do not model heat transfer, 1 = heat transfer is modelled

[ExternalCoupling]
0 										# 0 = no coupling, 1=coupling

[irrigation]
0                                      	# 0=ignore this module, 1 = run the module

[groundwater_flow] # FR
0                         				# 0=ignore the module, 1 = run the module

[soil_model]
0                        				# 0=ignore this module, 1 = run the module

[routing_model]
0                    					# 0=ignore this module, 1 = run the module, 2=run the module with observed inflows into the routing channels (from discharge files)

# declaring some common variables for vegetation period dependent grid-writing
# default (if not used in land use table at all) is JDVegReset = 1 and JDVegWrite = 365
$set $JDVegReset = 1
$set $JDVegWrite = 365

[multilayer_landuse]
1 # count of multilayer landuses
1  SRC_Reiff		{ Landuse_Layers = 101, -9999;	k_extinct = 0.3; LAI_scale = 20;}

[landuse_table]
# description of landuse, all 8 simulations are defined according to the "VersionNames" in Tabel 3
8
# LAI2000 Rsc40
101  poplar_SRC_13 {method 		= VariableDayCount; # DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			JulDays          =    15   120     121     134     140     150     166     178     186     190     197     213     228     235     238     246     260     270     277     292     293     349   ;
	        Albedo           =  0.17  0.17    0.17    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.17    0.17    0.17   ;
	        rsc              =   200   200      40      40      40      40      40      40      40      40      40      40      40      40      40      40      40      40      40      40     200     200   ;
		    rs_evaporation   =   750   750     750     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     750   ;       
		    LAI              =     1     1    1.02    1.89    2.03    2.43    2.97    3.34    3.73    4.45    4.74    5.45    5.41    4.83    4.17    3.70    3.30    3.02    2.68    1.65       1       1   ;
	        Z0               =  0.74  0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74   ;
	        VCF              =  0.65   0.8     0.8     0.9     0.9     0.9    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95     0.9     0.9     0.9    0.85    0.85    0.65   ;
	        RootDepth        =   1.0   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ;
			AltDep           = 0.025 0.025   0.025   0.025   0.025   0.025   0.025   0.025   0.025   0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025   ;
            n-factor         =   1.0   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ; 
			}
# LAI2000 Rsc80
102  poplar_SRC_13 {method 		= VariableDayCount; # DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          =    15   120     121     134     140     150     166     178     186     190     197     213     228     235     238     246     260     270     277     292     293     349   ;
	        Albedo           =  0.17  0.17    0.17    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.17    0.17    0.17   ;
	        rsc              =   200   200      80      80      80      80      80      80      80      80      80      80      80      80      80      80      80      80      80      80     200     200   ;
		    rs_evaporation   =   750   750     750     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     750   ;       
		    LAI              =     1     1    1.02    1.89    2.03    2.43    2.97    3.34    3.73    4.45    4.74    5.45    5.41    4.83    4.17    3.70    3.30    3.02    2.68    1.65       1       1   ;
	        Z0               =  0.74  0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74   ;
	        VCF              =  0.65   0.8     0.8     0.9     0.9     0.9    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95     0.9     0.9     0.9    0.85    0.85    0.65   ;
	        RootDepth        =   1.0   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ;
			AltDep           = 0.025 0.025   0.025   0.025   0.025   0.025   0.025   0.025   0.025   0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025   ;
            n-factor         =   1.0   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ; 
			}
# LI191SA Rsc40			
103  poplar_SRC_13 {method 		= VariableDayCount; # DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			JulDays          =    15     133     134     166     178     186     197     213     228     235     238     246     260     270     277     292     293     349   ;
	        Albedo           =  0.17    0.17    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.17    0.17    0.17   ;
	        rsc              =   200     200      40      40      40      40      40      40      40      40      40      40      40      40      40      40     200     200   ;
		    rs_evaporation   =   750     750     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     750   ;       
		    LAI              =     1       1    1.19    2.45    2.64    2.92    3.43    3.91    5.72    4.93    3.85    3.18    2.72    2.43    2.43    1.31       1       1   ;
	        Z0               =  0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74   ;
	        VCF              =  0.65     0.8     0.9    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95     0.9     0.9     0.9    0.85     0.7    0.65   ;
	        RootDepth        =   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ;
			AltDep           = 0.025   0.025   0.025   0.025   0.025   0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025   ;
            n-factor         =   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ; 
			}		
# LI191SA Rsc80	
104  poplar_SRC_13 {method 		= VariableDayCount; # DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			JulDays          =    15     133     134     166     178     186     197     213     228     235     238     246     260     270     277     292     293     349   ;
	        Albedo           =  0.17    0.17    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.18    0.17    0.17    0.17   ;
	        rsc              =   200     200      80      80      80      80      80      80      80      80      80      80      80      80      80      80     200     200   ;
		    rs_evaporation   =   750     750     800     800     800     800     800     800     800     800     800     800     800     800     800     800     800     750   ;       
		    LAI              =     1       1    1.19    2.45    2.64    2.92    3.43    3.91    5.72    4.93    3.85    3.18    2.72    2.43    2.43    1.31       1       1   ;
	        Z0               =  0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74    0.74   ;
	        VCF              =  0.65     0.8     0.9    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95    0.95     0.9     0.9     0.9    0.85     0.7    0.65   ;
	        RootDepth        =   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ;
			AltDep           = 0.025   0.025   0.025   0.025   0.025   0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025  -0.025   ;
            n-factor         =   1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0     1.0   ; 
			}
# LAIstep Rsc40 Max1
105  poplar_SRC_13 {method 		= DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			F*                	= 175;	# "Temperatursum" which must be exceeded for starting the phenological cycle (unfolding leaves)
			DP1_t1_dorm       	= 32;	# starting day (julian day number), forcing units will be summed up after this day of year
	        DP1_T_Bf          	= 0;	# threshold temperatur for a positive forcing unit after Model 12b (thermal time model)	
			DP4_t0_dorm 		= 304;	# November, 1st=304/305 # starting day (julian day number), chilling units will be summed up after this day of year
            DP4_t1_dorm 		= 32;	# February 2nd=32 # starting day (julian day number), forcing units will be summed up after this day of year
            DP4_T0 				= 10;	# threshold temperatur for chilling units (if T < T0)
            DP4_T1 				= 2;	# threshold temperatur for forcing units (T > T1)
            DP4_Par_a 			= 2200;	# tree specific parameter
            DP4_Par_b 			= -403;	# tree specific parameter
            DP4_T_xylstop 		= 8;	# threshold temperature, the moving average of temperature has to stay below for 5 days in order to start leave fall
            DP4_t_xs1 			= 243;  # 183;	# time of year (julian day number), the moving average analysis starts from (for start leave fall estimation)
            DP4_SPSLF 			= 6;    # 10;	# (SamplePointStartLeaveFall) sample point ID which is replaced by the day of start leave fall with the original value as latest time
	        JDReset_TStart    	= 1;	# Julian Day when TStart is reset to -1 and Forcing untis are reset to 0 for a new vegetation period  
			maxStartJDforDP1  	= 150;	# latest start day for the model run to use DynamicPhenology_1. If start date is after this date, then TStart is set to maxStartJDforDP1 minus the delta of the next column (e.g. 150 - 18 = 132), so we assume that this start date meets a fully developed vegetation. If start day is even after DP2_t0_dorm, then the next year will use DP1 only
	        JulDays          =   15    -1     +1    150     258     287     288     349     ;
	        Albedo           = 0.17  0.17   0.17  0.175    0.18   0.175    0.17    0.17     ;
	        rsc              =  200   200     40     40      40      40     200     200     ;
		    rs_evaporation   =  750   750    750    750     800     800     750     750     ;
		    LAI              =    1     1      6      6       6       6       1       1     ;
	        Z0               = 0.74  0.74   0.74   0.74    0.74    0.74    0.74    0.74     ;
 	        VCF              = 0.65   0.7    0.7   0.95    0.95     0.8     0.8    0.65     ;
	        RootDepth        = 1.0    1.0    1.0    1.0     1.0     1.0     1.0     1.0     ;
			AltDep           = 0.025    0      0  0.025  -0.025       0  -0.025  -0.025     ;
            n-factor         = 1.0    1.0    1.0    1.0     1.0     1.0     1.0     1.0     ;
			}	
# LAIstep Rsc40 IPG235
106  poplar_SRC_13 {method 		= DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			F*                	= 175;	# "Temperatursum" which must be exceeded for starting the phenological cycle (unfolding leaves)
			DP1_t1_dorm       	= 32;	# starting day (julian day number), forcing units will be summed up after this day of year
	        DP1_T_Bf          	= 0;	# threshold temperatur for a positive forcing unit after Model 12b (thermal time model)	
			DP4_t0_dorm 		= 304;	# November, 1st=304/305 # starting day (julian day number), chilling units will be summed up after this day of year
            DP4_t1_dorm 		= 32;	# February 2nd=32 # starting day (julian day number), forcing units will be summed up after this day of year
            DP4_T0 				= 8;	# threshold temperatur for chilling units (if T < T0)
            DP4_T1 				= 5;	# threshold temperatur for forcing units (T > T1)
            DP4_Par_a 			= 1693.4161;	# tree specific parameter
            DP4_Par_b 			= -301.9361;	# tree specific parameter
            DP4_T_xylstop 		= 8;	# threshold temperature, the moving average of temperature has to stay below for 5 days in order to start leave fall
            DP4_t_xs1 			= 243;  # 183;	# time of year (julian day number), the moving average analysis starts from (for start leave fall estimation)
            DP4_SPSLF 			= 6;    # 10;	# (SamplePointStartLeaveFall) sample point ID which is replaced by the day of start leave fall with the original value as latest time
	        JDReset_TStart    	= 1;	# Julian Day when TStart is reset to -1 and Forcing untis are reset to 0 for a new vegetation period  
			maxStartJDforDP1  	= 150;	# latest start day for the model run to use DynamicPhenology_1. If start date is after this date, then TStart is set to maxStartJDforDP1 minus the delta of the next column (e.g. 150 - 18 = 132), so we assume that this start date meets a fully developed vegetation. If start day is even after DP2_t0_dorm, then the next year will use DP1 only
	        JulDays          =   15    -1     +1    150     258     287     288     349     ;
	        Albedo           = 0.17  0.17   0.17  0.175    0.18   0.175    0.17    0.17     ;
	        rsc              =  200   200     40     40      40      40     200     200     ;
		    rs_evaporation   =  750   750    750    750     800     800     750     750     ;
		    LAI              =    1     1      6      6       6       6       1       1     ;
	        Z0               = 0.74  0.74   0.74   0.74    0.74    0.74    0.74    0.74     ;
 	        VCF              = 0.65   0.7    0.7   0.95    0.95     0.8     0.8    0.65     ;
	        RootDepth        = 1.0    1.0    1.0    1.0     1.0     1.0     1.0     1.0     ;
			AltDep           = 0.025    0      0  0.025  -0.025       0  -0.025  -0.025     ;
            n-factor         = 1.0    1.0    1.0    1.0     1.0     1.0     1.0     1.0     ;
			}			
# LAIadjusted Rsc40adjusted Max1
107  poplar_SRC_13 {method 		= DynamicPhenology_4; 
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			F*                	= 175;	# "Temperatursum" which must be exceeded for starting the phenological cycle (unfolding leaves)
			DP1_t1_dorm       	= 32;	# starting day (julian day number), forcing units will be summed up after this day of year
	        DP1_T_Bf          	= 0;	# threshold temperatur for a positive forcing unit after Model 12b (thermal time model)	
			DP4_t0_dorm 		= 304;	# November, 1st=304/305 # starting day (julian day number), chilling units will be summed up after this day of year
            DP4_t1_dorm 		= 32;	# February 2nd=32 # starting day (julian day number), forcing units will be summed up after this day of year
            DP4_T0 				= 10;	# threshold temperatur for chilling units (if T < T0)
            DP4_T1 				= 2;	# threshold temperatur for forcing units (T > T1)
            DP4_Par_a 			= 2200;	# tree specific parameter
            DP4_Par_b 			= -403;	# tree specific parameter
            DP4_T_xylstop 		= 8;	# threshold temperature, the moving average of temperature has to stay below for 5 days in order to start leave fall
            DP4_t_xs1 			= 243; # 183;	# time of year (julian day number), the moving average analysis starts from (for start leave fall estimation)
            DP4_SPSLF 			= 9;	# (SamplePointStartLeaveFall) sample point ID which is replaced by the day of start leave fall with the original value as latest time
	        JDReset_TStart    	= 1;	# Julian Day when TStart is reset to -1 and Forcing untis are reset to 0 for a new vegetation period  
			maxStartJDforDP1  	= 150;	# latest start day for the model run to use DynamicPhenology_1. If start date is after this date, then TStart is set to maxStartJDforDP1 minus the delta of the next column (e.g. 150 - 18 = 132), so we assume that this start date meets a fully developed vegetation. If start day is even after DP2_t0_dorm, then the next year will use DP1 only
	        JulDays          = 15    46    -1    +20   166    196    227    258    288    319    349    ;
	        Albedo           = 0.17  0.17  0.17  0.17  0.18   0.18   0.18   0.18   0.175  0.17   0.17   ; # Albedo (snow free) 
	        rsc              = 200   200   150   60    40     40     40     60     60     200    200    ; # leaf surface resistance in s/m   
		    rs_evaporation   = 750   750   750   750   800    800    800    800    800    750    750    ; # SOIL surface resistance in s/m (for evaporation only) [150 ...250 s/m]
		    LAI              = 1     1     2     3.5   5      6      6      5      3      1      1      ; # Leaf Area Index (1/1)
	        Z0               = 0.74  0.74  0.74  0.74  0.74   0.74   0.74   0.74   0.74   0.74   0.74   ; # Roughness length in m # FR z0=0.123*h (0.123*6m=0.74)
	        VCF              = 0.65  0.65  0.7   0.8   0.95   0.95   0.95   0.9    0.85   0.65   0.65   ; # Vegetation covered fraction ("Vegetationsbedeckungsgrad") 
	        RootDepth        = 1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0    ; # Root depth in m
			AltDep           = 0.025 0.025 0     0     0.025 -0.025 -0.025 -0.025  0     -0.025 -0.025  ; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben). Parameter beziehen sich auf 400m..NN			
            n-factor         = 1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0    ;
			}
# LAIadjusted Rsc40adjusted IPG235
108  poplar_SRC_13 {method 		= DynamicPhenology_4;
	        RootDistr       	= 1;	# [-1: konkav, 0: linear, >1: konvex]
	        TReduWet         	= 1;	# relative Theta value for beginning oxygen stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     	= 0.5;	# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         	= 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      	= 0.3;	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
			F*                	= 175;	# "Temperatursum" which must be exceeded for starting the phenological cycle (unfolding leaves)
			DP1_t1_dorm       	= 32;	# starting day (julian day number), forcing units will be summed up after this day of year
	        DP1_T_Bf          	= 0;	# threshold temperatur for a positive forcing unit after Model 12b (thermal time model)	
			DP4_t0_dorm 		= 304;	# November, 1st=304/305 # starting day (julian day number), chilling units will be summed up after this day of year
            DP4_t1_dorm 		= 32;	# February 2nd=32 # starting day (julian day number), forcing units will be summed up after this day of year
            DP4_T0 				= 8;	# threshold temperatur for chilling units (if T < T0)
            DP4_T1 				= 5;	# threshold temperatur for forcing units (T > T1)
            DP4_Par_a 			= 1693.4161;	# tree specific parameter
            DP4_Par_b 			= -301.9361;	# tree specific parameter
            DP4_T_xylstop 		= 8;	# threshold temperature, the moving average of temperature has to stay below for 5 days in order to start leave fall
            DP4_t_xs1 			= 243; # 183;	# time of year (julian day number), the moving average analysis starts from (for start leave fall estimation)
            DP4_SPSLF 			= 9;	# (SamplePointStartLeaveFall) sample point ID which is replaced by the day of start leave fall with the original value as latest time
	        JDReset_TStart    	= 1;	# Julian Day when TStart is reset to -1 and Forcing untis are reset to 0 for a new vegetation period  
			maxStartJDforDP1  	= 150;	# latest start day for the model run to use DynamicPhenology_1. If start date is after this date, then TStart is set to maxStartJDforDP1 minus the delta of the next column (e.g. 150 - 18 = 132), so we assume that this start date meets a fully developed vegetation. If start day is even after DP2_t0_dorm, then the next year will use DP1 only
	        JulDays          = 15    46    -1    +20   166    196    227    258    288    319    349    ;
	        Albedo           = 0.17  0.17  0.17  0.17  0.18   0.18   0.18   0.18   0.175  0.17   0.17   ; # Albedo (snow free) 
	        rsc              = 200   200   150   60    40     40     40     60     60     200    200    ; # leaf surface resistance in s/m   
		    rs_evaporation   = 750   750   750   750   800    800    800    800    800    750    750    ; # SOIL surface resistance in s/m (for evaporation only) [150 ...250 s/m]
		    LAI              = 1     1     2     3.5   5      6      6      5      3      1      1      ; # Leaf Area Index (1/1)
	        Z0               = 0.74  0.74  0.74  0.74  0.74   0.74   0.74   0.74   0.74   0.74   0.74   ; # Roughness length in m # FR z0=0.123*h (0.123*6m=0.74)
	        VCF              = 0.65  0.65  0.7   0.8   0.95   0.95   0.95   0.9    0.85   0.65   0.65   ; # Vegetation covered fraction ("Vegetationsbedeckungsgrad") 
	        RootDepth        = 1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0    ; # Root depth in m
			AltDep           = 0.025 0.025 0     0     0.025 -0.025 -0.025 -0.025  0     -0.025 -0.025  ; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben). Parameter beziehen sich auf 400m..NN			
            n-factor         = 1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0    ;
			}
			
$set $e3 = e-2
$set $e4 = e-3				
$set $e5 = e-4				
$set $e6 = e-5				
$set $e7 = e-6				
$set $e8 = e-7				
$set $e9 = e-8				
$set $e10 = e-9				
				
				
[soil_table]
1                  # number of following entries
1 ReiffRef		{method = MultipleHorizons;
				# max 11 default parameters SU_PAR00 to SU_PAR10 for silting up module. These parameters can be used when defining expressions for inf_infinite (Y), energy (W), SDISP (Z), inf_start(X), and inf_pot (V) in method 3
				 SU_PAR01 = 65.0;		# for method 3:  parameter A in I_0 = A (initial infiltration capacity, in method 0 defined as 65 mm/h)
				 SU_PAR02 = 12.2;		# for method 3:  parameter B in I_end = B*(dg^C)*(fd^D) (in method 0 defined as 12.2)
				 SU_PAR03 = 0.52;		# for method 3:  parameter C in I_end = B*(dg^C)*(fd^D) (in method 0 defined as 0.52)
				 SU_PAR04 = -0.64;		# for method 3:  parameter D in I_end = B*(dg^C)*(fd^D) (in method 0 defined as -0.64)
				 SU_PAR05 = 0.013;		# for method 3:  parameter E in Cv = E*(fd^F)*(dg^G)*(t_cult^H) (in method 0 defined as 0.013)
				 SU_PAR06 = -1.03;		# for method 3:  parameter F in Cv = E*(fd^F)*(dg^G)*(t_cult^H) (in method 0 defined as -1.03)
				 SU_PAR07 = 0.7;		# for method 3:  parameter G in Cv = E*(fd^F)*(dg^G)*(t_cult^H) (in method 0 defined as 0.7)
				 SU_PAR08 = -0.19;		# for method 3:  parameter H in Cv = E*(fd^F)*(dg^G)*(t_cult^H) (in method 0 defined as -0.19)
#				 FCap = 6.21; mSB = 38.5; ksat_topmodel = 8.25E-5; suction = 385; # optional parameters which are needed for Topmodel only
				 GrainSizeDist    = 0.67 0.21 0.12; 	# optional: when using silting up model, the grain size fractions for sand, silt, clay, (and Stones1..4  must be given here. Stones1 = 2-6.3mm, Stones2=6.3-20mm, Stones3=20-63mm, Stones4=63-200mm.)
				 PMacroThresh  	  = 0.375 				# precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity 	  = 0.125  				# capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu  	  = 0.7					# reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth    	  = 0.9					# maximum depth of the macropores
				 KMinFrozenSoil   = 1e-12				# minimum hydraulic conductivity in m/s when the soil is completely frozen (do not set to zero, since the logarithm of this value is used internally) 
				horizon			= 1			2			3			;	# ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				Name			= Lu		Ls3			Ls4			;	# short descriptions
				ksat			= 2.5694e-5	1.9664e-5	1.6354e-5	;	# saturated hydraulic conductivity	in m/s # FR aus KA5 (2005)
				k_recession		= 0.99		0.99		0.99		;	# k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
				theta_sat		= 0.37		0.37		0.37		;	# saturated water content (fillable porosity in 1/1)
				theta_res		= 0.05		0.07 		0.05 		;	# residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
				alpha			= 4.321		6.835		9.955		;	# van Genuchten Parameter Alpha (small values for silt of  e.g. 0.5 to high values of e.g. 4 to 8 for sand, gravel and peat
				Par_n			= 1.16518	1.20501		1.18213		;	# van Genuchten Parameter n (1.5 for silt to 4.5 for gravel and peat)
				Par_tau			= 0.5		0.5			0.5			;	# sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5) 
				thickness		= 0.05		0.1			0.1			;	# thickness of each single numerical layer in this horizon in m
				layers			= 6			6			12			;	# numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
				}					

[substance_transport]
0

[irrigation_table]
0                  # number of following irrigation codes, per row one use

[special_output] # FR
0 # 0=do not run this module, 1=run this module
