function urlStr = uptree(n,varargin)
% % ---------------------------------------------------------------------
% % UPTREE(N) is similar to PWD; it returns the url of the directory     
% % which is located N levels up from the current directory. This is     
% % useful when loading files that are located relative to the current   
% % directory.                                                            
% %                                                                      
% % Of course, this can be overcome by using the absolute address to the 
% % data file, but only at the cost of decreased portability.            
% %                                                                      
% % UPTREE(0) is equivalent to PWD, except that the UPTREE result always 
% % ends in a FILESEP.                                                   
% % ---------------------------------------------------------------------
% % UPTREE(N,DIR) goes up N directories from DIR.                        
% % ---------------------------------------------------------------------
% % 


if nargin==0
    help uptree
    return
end

if ~isnumeric(n)
    error(['First input argument to ',char(39),mfilename,char(39),' should be a number.'])
end

if nargin==1
    dirStr = pwd;
else
    if ~ischar(varargin{1})
        error(['Second input argument to ',char(39),mfilename,char(39),' should be a directory string.'])
    end
    dirStr = varargin{1};
end

if ~strcmp(dirStr(end),filesep)
    dirStr = [dirStr,filesep];
end    
    
    

Ix = strfind(dirStr,filesep);
N=numel(Ix);
if (N-n)<=0
    error(['Can',char(39),'t go up that many levels.'])
else
    urlStr = dirStr(1:Ix(N-n));
end



