function varargout = subplotScreen(varargin)

if nargin == 0
    nRows = 1;
    nCols = 1;
    figIndex = 1;
    startAt = 1;
elseif nargin==1 && strcmp(varargin{1},'refresh')
    % doc hgrc 
    % this section should reset the monitor positions...still working on
    % a fix... screensize property is static
    disp('')
    return
else
    nRows = varargin{1};
    nCols = varargin{2};
    figIndex = varargin{3};
    startAt = 4;
end
iMonitor = 1;

    


authorizedOptions = {'rect','border','figureNumber','name','iMonitor'};
for k = startAt:2:length(varargin(:))
    if ~strcmp(varargin{k}, authorizedOptions)
        s=dbstack;
        error(['Unauthorized parameter name ' 39 varargin{k} 39 ' in ' 10,...
            'parameter/value passed to ' 39 s(end-1).name 39 '.']);
    end
    eval([varargin{k},'=varargin{',num2str(k+1),'};'])
end
if ~isempty(varargin)
    clear k
end



% screenSize = get(0,'screensize');
monitorPositions = get(0,'MonitorPositions');
screenRect = monitorPositions(iMonitor,:);

if exist('rect','var')==0
    f = 0.45;
    sw = screenRect(3)-screenRect(1);
    sh = screenRect(4)-screenRect(2);
    hfw = floor(f*sw);
    hfh = floor(f*sh);
    mx = floor(screenRect(1)+0.5*sw);
    my = floor(screenRect(4)+0.5*sh);
    
    rect = [mx-hfw,monitorPositions(1,4)-monitorPositions(iMonitor,2)-floor(0.5*sh)-hfh,2*hfw,2*hfh];
end

name = '';
border = [86,9,0,9];

if ~exist('figureNumber','var')
    existingFigures = get(0,'children');
    figureNumber = 1;
    while true
        if ismember(figureNumber,existingFigures)
            figureNumber = figureNumber+1;
        else
            break
        end
    end
end


curRectWidth = floor(rect(3)/nCols);
curRectHeight = floor(rect(4)/nRows);


colNumber = mod(figIndex-1,nCols)+1;
rowNumber = 1+(figIndex-colNumber)/nCols;

if ~(1<=colNumber && colNumber<=nCols)||...
   ~(1<=rowNumber && rowNumber<=nRows)

    error('Figure number out of bounds.')
    
end

curRectLeft = rect(1)+((colNumber-1)*curRectWidth)+1;
curRectBottom = rect(2)+(nRows-rowNumber)*curRectHeight+1;


h=figure(figureNumber);
set(h,'position',[curRectLeft + border(4),...
                     curRectBottom + border(3),...
                     curRectWidth - border(2) - border(4),...
                     curRectHeight - border(1) - border(3)]);

set(h,'name',name)


if nargout==1
    varargout={h};
end
                 
                 