function varargout = imagescv(xv,yv,Z,cMap,cLimLow,cLimHigh)

unitRectX = [-1,1,1,-1,-1]*0.5;
unitRectY = [1,1,-1,-1,1]*0.5;

nCols = numel(xv);
nRows = numel(yv);

if numel(xv)>1
    resX = xv(2)-xv(1);
else
    resX = 1;
end
if numel(yv)>1
    resY = yv(2)-yv(1);
else
    resY = 1;
end

nColors = size(cMap,1);

x = linspace(cLimLow,cLimHigh,nColors+1);
xMid = mean([x(1:end-1);x(2:end)],1);

handles = repmat(NaN,size(Z));

for iRow = 1:nRows
    for iCol = 1:nCols
        
        handles(iRow,iCol) = patch(xv(iCol)+unitRectX*resX,yv(iRow)+unitRectY*resY,'k');

        if Z(iRow,iCol)>xMid(end)
            faceColor = cMap(end,1:3);
        elseif Z(iRow,iCol)<xMid(1)
            faceColor = cMap(1,1:3);
        else
            faceColor = interp1(xMid,cMap,Z(iRow,iCol),'nearest');
        end
        set(handles(iRow,iCol),'facecolor',faceColor,'edgecolor',faceColor)
    
    end
end

set(gca,'ydir','reverse',...
        'layer','top')


if nargout == 1
    varargout{1}=handles;
end

