function varargout = colorbarv(cMap,cLimLow,cLimHigh)

nColors = size(cMap,1);

handles{1} = colorbar;
pos = get(handles{1},'position');
set(handles{1},'visible','off')

axes('position',pos,'layer','top')

v = linspace(cLimLow,cLimHigh,nColors+1);
mids = mean([v(1:end-1);v(2:end)],1);

handles{2} = imagescv(1,mids,mids',cMap,cLimLow,cLimHigh);
set(gca,'yaxislocation','right',...
    'xtick',[],...
    'ydir','normal',...
    'xlim',[0.5,1.5],...
    'ylim',[cLimLow,cLimHigh],...
    'layer','top')
box on


if nargout == 1
    varargout{1}=handles;
end