function sodaPlotPersistence(sodaPar,sequences,varargin)

plotMode = 'maximum'; % increment
showLines = false;

authorizedOptions = {'plotMode';...
                     'showLines'};

sodaParsePairs



if sodaPar.nCompl>10
    cVec = linspace(0.2,0.8,ceil((sodaPar.nCompl-10)^(1/3)));
    extraColors = sodaAllComb(cVec,cVec,cVec);
else
    extraColors=[];
end
    
defaultColors = [0,0,1;...
            0,0.5,0;
            1,0,0;...
            1,0.5,0;...
            1,1,0;...
            0.5882,0.7216,0.1804;...
            0,1,1;...
            1,0,1;...
            0.7529,0.7529,0.7529;...
            0.1490,0.5333,0.7176;
            extraColors];
        
        
        

nSeq = sodaPar.nCompl;

persistence = repmat(NaN,[size(sequences,1),2,nSeq]);
persistence(:,1,:) = sequences(:,1,:);

persistenceHist = persistence;

for iSeq = 1:nSeq
    
    v=1;
    
    for k=1:size(persistence,1)
        
        if sequences(k,sodaPar.parCols,iSeq)~=sequences(v,sodaPar.parCols,iSeq)
            persistenceHist(v,2,iSeq) = k-v;
            switch plotMode
                case 'maximum'
                    persistence(v:k-1,2,iSeq) = k-v;
                case 'increment'
                    persistence(v:k-1,2,iSeq) = 1:k-v;
                otherwise
            end
            v = k;
        end
    end
    
    
    switch plotMode
        case 'maximum'
            persistence(v:k,2,iSeq) = k-v+1;
        case 'increment'
            persistence(v:k,2,iSeq) = 1:k-v+1;
        otherwise
    end
  

    persistenceHist(v,2,iSeq) = k-v+1;   
    
end

% % % % % % % % % % 





set(gcf,'numbertitle','off','name',mfilename)
subplot(2,1,1)
for iSeq = 1:nSeq
    h=plot(persistence(:,1,iSeq),persistence(:,2,iSeq),...
        'markeredgecolor',defaultColors(iSeq,:),...
        'markerfacecolor',defaultColors(iSeq,:),...        
        'marker','s',...
        'markersize',3);
    if showLines
        set(h,'color',0.9*[1,1,1])
    else
        set(h,'linestyle','none')
    end
    hold on
end
hold off
ylabel('persistence')
xlabel('iteration')


subplot(2,1,2)
M = shiftdim(persistenceHist(:,2,:),2)';
maxM = max(M(:));
if maxM>1
    hist(M,[1:max(M(:))])
else
    hist(M)
    set(gca,'xlim',[0,2])
end

h = findobj(gca,'Type','patch');
for iSeq = 1:nSeq
    set(h(iSeq),'FaceColor',defaultColors(nSeq-iSeq+1,:),'EdgeColor',defaultColors(nSeq-iSeq+1,:))
end

xlabel('persistence')
ylabel('count')




