function varargout = sodaPlotPaCo(scemPar,evalResults,varargin)

standardize = true;
invAxis = repmat(false,[1,scemPar.nOptPars]);

nRows = size(evalResults,1);
nSamples = scemPar.nSamples;
iterSelection = nRows+[-5*nSamples+1:0];

authorizedOptions = {'standardize',...
                     'invAxis',...
                     'iterSelection'};

% parse input from varargin here
sodaParsePairs


parCols = scemPar.parCols;
nSamples = numel(iterSelection);

muRecords = repmat(mean(evalResults(iterSelection,parCols),1),[nSamples,1]);

flag = 0; % standard deviation calculated with n-1 in the divisor

sigmaRecords = repmat(std(evalResults(iterSelection,parCols),flag,1),[nSamples,1]);


invArray = repmat((~invAxis)*1+invAxis*-1,[nSamples,1]);


if standardize
    M = invArray.*(evalResults(iterSelection,parCols)-muRecords)./sigmaRecords;
else
    M = invArray.*evalResults(iterSelection,parCols);
end

minLim = min(M(:));
maxLim = max(M(:));

hold on
for k=scemPar.parCols
    if invAxis(1,k-1)
        s = '-1\cdot';
    else
        s = '';
    end
    if numel(scemPar.parNamesTex)>=(k-1) && ~isempty(scemPar.parNamesTex{k-1})
        arrayOfHandles(k-1,1) = text(k,minLim+(maxLim-minLim)*1.05,...
            [s,scemPar.parNamesTex{k-1}],...
            'interpreter','tex',...
            'horizontalalign','center',...
            'verticalalignment','middle');
    else
        arrayOfHandles(k-1,1) = text(k,minLim+(maxLim-minLim)*1.05,...
            [s,scemPar.parMap{k-1}],...
            'interpreter','none',...
            'horizontalalign','center',...
            'verticalalignment','middle');
    end
end


arrayOfHandles(scemPar.nOptPars+[1:scemPar.nOptPars],1) =...
    plot([scemPar.parCols;scemPar.parCols],[minLim;maxLim],...
    'color',0.8*[1,1,1]);

arrayOfHandles(2*scemPar.nOptPars+[1:nSamples],1) = plot(scemPar.parCols,M,'-k');

set(gca,'xlim',[min(scemPar.parCols),max(scemPar.parCols)]+[-1,1]*0.5)
set(gca,'ylim',[minLim,maxLim])
set(gca,'xtick',scemPar.parCols,'xticklabel',{})


if standardize
    arrayOfHandles(end+1,1) = ylabel('normalized parameter value');
else
    arrayOfHandles(end+1,1) = ylabel('parameter value');
end



set(gcf,'numbertitle','off','name',mfilename)




if nargout==1
    varargout = arrayOfHandles;
end