function varargout=sodaMargHist(sodaPar,evalResults,varargin)

% assign default options:
windowState = 'unspecified';
histMode='absolute';
nBins = min([50,round(sodaPar.nSamples/5)]);
N = min([size(evalResults,1),5*sodaPar.nSamples]);
iterSelection = size(evalResults,1)+(-N+1:0);
clear N
%faceColor = [0.42,0.84,0];
faceColor = [0.9373,0.6863,0.1608];
edgeColor = faceColor;
fixedBinEdges = false;
showNumberOfPoints = true;
xScale={};
yScale={};
printToFile = false;
printToPNG = false;
printToEPS = false;

authorizedOptions = {'windowState',...
                     'histMode',...
                     'nBins',...
                     'iterSelection',...
                     'faceColor',...
                     'edgeColor',...
                     'fixedBinEdges',...
                     'showNumberOfPoints',...
                     'xScale',...
                     'yScale',...
                     'printToFile',...
                     'printToPNG',...
                     'printToEPS'};
                 
% overrule default options with user-specified options:                 
sodaParsePairs

nPoints = numel(iterSelection);

M = evalResults(iterSelection,:);
H=repmat(NaN,[numel(sodaPar.parCols),1]);


for r=1:numel(sodaPar.parCols)
    xScale2{r,1}=r;
    xScale2{r,2}=cellfind(xScale,r);
    yScale2{r,1}=r;
    yScale2{r,2}=cellfind(yScale,r);
end
xScale = xScale2;
yScale = yScale2;
clear xScale2
clear yScale2



for p=sodaPar.parCols-1
    
    H(p)=subplot(sodaPar.nOptPars,1,p);
    
    a = sodaPar.parSpaceLoBound(p);
    b = sodaPar.parSpaceHiBound(p);
    
    if fixedBinEdges  
        c = a;
        e = b;
    else
        c = min(M(:,p+1));
        d = max(M(:,p+1));
        e = d+(d-c)*1e-8;
    end

    clear d
    
    binEdges = linspace(c,e,nBins+1);
    dx = binEdges(2)-binEdges(1);
    
    switch histMode
        case 'absolute'
            histcResult = histc(M(:,p+1),binEdges);
        case 'relative'
            nRecords = size(M,1);
            histcResult = histc(M(:,p+1),binEdges)/nRecords;
        otherwise
            error(['Unknown option in function ', mfilename])
    end
    [xb,yb]=stairs([c,binEdges,e],[0,histcResult',0]);
    patchHandle = patch(xb,yb,'k');
    set(patchHandle,'FaceColor',faceColor,'EdgeColor',edgeColor)
    set(gca,'xscale',xScale{p,2},'yscale',yScale{p,2})
    set(gca,'xlim',[a,b])
    
    box on
    
    if isfield(sodaPar,'parNamesTex')&&...
            numel(sodaPar.parNamesTex)>=p&&...
            ~isempty(sodaPar.parNamesTex{p})
        if showNumberOfPoints
            title([sodaPar.parNamesTex{p},' (N = ',num2str(nPoints),')'],'interpreter','tex')
        else
            title(sodaPar.parNamesTex{p},'interpreter','tex')
        end
    else
        if showNumberOfPoints
            title([sodaPar.parNames{p},' (N = ',num2str(nPoints),')'],'interpreter','none')
        else
            title(sodaPar.parNames{p},'interpreter','none')
        end
    end
    
    if p==sodaPar.parCols(end)-1
            xlabel('parameter value')
    end
    switch histMode
        case 'absolute'
            ylabel('count')
        case 'relative'
            ylabel('frequency')
        otherwise
            warning('Unrecognized histMode.')
    end

end

set(gcf,'name',mfilename,'numbertitle','off')



if uimatlab
    % This code block will only be useful when I find a way to get the
    % window state, or when I can plot something without bringing up the
    % window.
    try
        switch windowState
            case 'unspecified'
                % do nothing
            case 'minimized'
                setWindowState(gcf,'minimize')
            case 'maximized'
                setWindowState(gcf,'maximized')
            case 'restore'
                setWindowState(gcf,'restore')
            otherwise
                error('Unknown window state')
        end
    catch
    end
end



if nargout==2
    varargout{1}=binEdges;
    varargout{2}=histcResult;
elseif nargout==3
    varargout{1}=binEdges;
    varargout{2}=histcResult;
    varargout{3}=H;
end

if printToPNG||printToFile
    print(mfilename,'-dpng','-r300')
end
if printToEPS||printToFile
    print(mfilename,'-depsc','-r300')
end



% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

function scaleType=cellfind(C,subplotIx)
scaleType='linear';
for r=1:size(C,1)
    if C{r,1}==subplotIx
        scaleType = C{r,2};
        return
    end
end