function sodaVerifyFieldNames(sodaPar,modeStr)

authorizedFieldNames =...
    {'badScore',...
    'cBeta',...
    'convMaxDiff',...
    'convUseLastFraction',...
    'converged',...
    'crashAndBurn',...
    'critGelRubConvd',...
    'doPlot',...    
    'drawInterval',...
    'evalCol',...
    'errModelCallStr',...
    'forceRecalcFraction',...
    'initState',...
    'initStateErr',...
    'initStateRef',...
    'iterator',...
    'iterCol',...
    'jumpRate',...
    'kurt',...
    'measErr',...
    'measNames',...
    'modeGelRub',...
    'modeStr',...
    'modelName',...
    'nCompl',...
    'nEnsembleMembers',...
    'nGelRub',...
    'nMeasurements',...
    'nModelEvalsMax',...
    'nOffspring',...
    'nOffspringFraction',...
    'nOffspringPerCompl',...
    'nOptPars',...
    'nOutputs',...
    'nSamples',...
    'nSamplesPerCompl',...
    'nStatesKF',...
    'nStatesNOKF',...
    'nStatesViz',...
    'objCallStrs',...
    'objCol',...
    'objTexNames',...
    'obsPoints',...
    'omegaBeta',...
    'optEndTime',...
    'optMethod',...
    'parCols',...
    'paretoMethod',...
    'parNames',...
    'parNamesTex',...
    'parSpaceHiBound',...
    'parSpaceLoBound',...
    'plotEnsemble',...
    'randSeed',...
    'realPartOnly',...
    'sampleDrawMode',...
    'saveInterval',...
    'simPoints',...
    'ssp',...
    'startFromUniform',...
    'stateNamesKF',...
    'stateNamesNOKF',...
    'stateSpaceHiBound',...
    'stateSpaceLoBound',...
    'statesViz',...
    'stochForcePars',...
    'stochForceParsIx',...
    'thresholdL',...
    'verboseOutput',...
    'visualizationCall',...
    'vizWindow'};


switch modeStr
    case 'check'
        F = fieldnames(sodaPar);
        for k=1:numel(F)
            if ~any(strcmp(F{k},authorizedFieldNames))
                error(['Unrecognized field ',char(39),F{k},char(39),...
                    ' in variable sodaPar.'])
            end

        end
    case 'show'
        disp(sprintf('%s\n',authorizedFieldNames{:}))
end

