function sodaTerminateWorkers(sodaPar)

if nargin==0
    error('sodaPar should be input argument')
end


% assign jobs to workers:
%
for iWorker = 1:sodaPar.ssp.nWorkers
    
    evalResultsPart = [-1,repmat(NaN,[1,sodaPar.nOptPars+sodaPar.nObjs+1]),false];
    
    % set status to 'a': master is writing job
    sodaSspSetStatus(iWorker,'a')
    
    % write the job:
    mConstants = NaN;%evalin('base','mConstants');
    mStatesNOKFInit = NaN;%evalin('base','mStatesNOKFInit');
    workerInstruction = 'terminate';
    jobFile = fullfile(pwd,['worker',sprintf('%03d',iWorker)],'job.mat');
    save(jobFile,'evalResultsPart','sodaPar','mConstants','mStatesNOKFInit','workerInstruction')
    
    % set status to 'b': master has finished writing job/ control is passed
    % to worker:
    sodaSspSetStatus(iWorker,'b')
    
end

