function uDraw = sodaUnifRandDraw(sodaPar,drawMode)
%
% <a href="matlab:web(fullfile(scemroot,'html','latin.html'),'-helpbrowser')">View HTML documentation for this function in the help browser</a>    
%

% This code has been revised by JHS2007
switch drawMode
    case 'stateSpace'
       
        nStates = sodaPar.nStates;
        nMembers = sodaPar.nEnsembleMembers;
        stateSpaceHiBound = sodaPar.stateSpaceHiBound;
        stateSpaceLoBound = sodaPar.stateSpaceLoBound;
        
        stateSpaceRange = stateSpaceHiBound-stateSpaceLoBound;
        
        rangeWidth = repmat(stateSpaceRange,[1,1,nMembers]);
        rangeMin = repmat(stateSpaceLoBound,[1,1,nMembers]);
        uDraw = rangeMin + rand(1,nStates,nMembers).*rangeWidth;
        
    case 'parSpace'
        nOptPars = sodaPar.nOptPars;
        nSamples = sodaPar.nSamples;
        parSpaceHiBound = sodaPar.parSpaceHiBound;
        parSpaceLoBound = sodaPar.parSpaceLoBound;

        rangeWidth = repmat(parSpaceHiBound-parSpaceLoBound,[nSamples,1]);
        rangeMin = repmat(parSpaceLoBound,[nSamples,1]);
        uDraw = rangeMin + rand(nSamples,nOptPars).*rangeWidth;
    otherwise
        error('unknown drawmode.')
        
end
