function varargout = sodaInitialize(sodaOptions)

sodaPar.verboseOutput = true;
if nargin>1 && ischar(sodaOptions{2})
    switch sodaOptions{2}
        case {'-q','-quiet'}
            sodaPar.verboseOutput = false;
        otherwise
            sodaPar.verboseOutput = true;
    end

end

switch sodaOptions{1}
    case '-docinstall'
        %             try
        try
            if sodaPar.verboseOutput
                soda('-addtools')
            else
                soda('-addtools','-quiet')
            end

            fid=fopen(fullfile(sodaroot,'info.xml.template'),'r');
            textInfoXML='';
            while true
                tline = fgets(fid);
                if ischar(tline)
                    textInfoXML = [textInfoXML,tline];
                else
                    break
                end
            end
            fclose(fid);

            fid=fopen(fullfile(sodaroot,'info.xml'),'wt');
            fprintf(fid,textInfoXML,sodaroot);
            fclose(fid);

            if sodaPar.verboseOutput
                disp(['SODA: ',char(39),'info.xml',char(39),' file ',...
                    'written successfully. '])
            end

        catch
            if sodaPar.verboseOutput
                warning('SODA:writing_of_info_file',...
                    ['An error occurred during writing ',...
                    'of SODA ',char(39),...
                    'info.xml',char(39),' file'])
            end
        end
        try
            soda('-update-version-file')
        catch
            warning('SODA:writing_of_version_file',...
                ['An error occurred during writing ',...
                'of SODA ',char(39),...
                'version-helper.txt',char(39),' file'])
        end
        try
            if uimatlab

                Colors_M_CommentsStr = '228B22';
                Colors_M_StringsStr = 'A020F0';
                Colors_M_KeywordsStr = '0000FF';
                Colors_M_SystemCommandsStr = 'B28C00';

                prefFile = fullfile(prefdir,'matlab.prf');
                if exist(prefFile,'file')==2

                    fid=fopen(prefFile,'r');
                    C = textscan(fid, '%s','delimiter','\r');
                    fclose(fid);

                    for k=1:numel(C{1})
                        try
                            MatlabVarName = strread(C{1}{k},'%[^=]',1);
                            switch MatlabVarName{1}
                                case 'Colors_M_Comments'
                                    indColor = strread(C{1}{k},'%*[^=]%*[=]%s',1);
                                    [r,g,b]=indexed2hexcolor(indColor{1});
                                    Colors_M_CommentsStr =...
                                        [dec2hex(r,2),dec2hex(g,2),dec2hex(b,2)];
                                case 'Colors_M_Strings'
                                    indColor = strread(C{1}{k},'%*[^=]%*[=]%s',1);
                                    [r,g,b]=indexed2hexcolor(indColor{1});
                                    Colors_M_StringsStr =...
                                        [dec2hex(r,2),dec2hex(g,2),dec2hex(b,2)];
                                case 'Colors_M_Keywords'
                                    indColor = strread(C{1}{k},'%*[^=]%*[=]%s',1);
                                    [r,g,b]=indexed2hexcolor(indColor{1});
                                    Colors_M_KeywordsStr =...
                                        [dec2hex(r,2),dec2hex(g,2),dec2hex(b,2)];
                                case 'Colors_M_SystemCommands'
                                    indColor = strread(C{1}{k},'%*[^=]%*[=]%s',1);
                                    [r,g,b]=indexed2hexcolor(indColor{1});
                                    Colors_M_SystemCommandsStr =...
                                        [dec2hex(r,2),dec2hex(g,2),dec2hex(b,2)];
                            end
                        catch

                        end
                    end
                end

                fid=fopen(fullfile(sodaroot,'html','styles',...
                    'soda_styles.css.template'),'r');
                textStylesCSS='';
                while true
                    tline = fgets(fid);
                    if ischar(tline)
                        textStylesCSS = [textStylesCSS,tline];
                    else
                        break
                    end
                end
                fclose(fid);


                fid=fopen(fullfile(sodaroot,'html','styles',...
                    'soda_styles.css'),'wt');
                fprintf(fid,textStylesCSS,...
                    Colors_M_CommentsStr,...
                    Colors_M_StringsStr,...
                    Colors_M_KeywordsStr,...
                    Colors_M_SystemCommandsStr);
                fclose(fid);


                if sodaPar.verboseOutput
                    disp(['SODA: ',char(39),'soda_styles.css',char(39),' has been updated successfully.'])
                end

                if sodaPar.verboseOutput && uimatlab
                    disp(['Click on the MATLAB ',...
                        'Start button->Desktop Tools->View Start Button Configuration Files...',...
                        char(10),'...and click Refresh Start Button.'])
                end

            else
                if uioctave
                    disp('You seem to be on octave. CSS files not written. Never mind.')
                end
            end
        catch
            if sodaPar.verboseOutput
                warning('SODA:writing_of_styles_file',...
                    ['An error occurred during writing ',...
                    'of soda ',char(39),...
                    'soda_styles.css',char(39),' file'])
            end
        end
        %     end

    case '-addtools'
        try

            p = mfilename('fullpath');
            u = findstr(p,mfilename);
            addpath(fullfile(p(1:u(end)-1),'tools'))
            addpath(fullfile(sodaroot,'visualization'))
            addpath(fullfile(sodaroot,'enkf'))
            addpath(fullfile(sodaroot,'ssp'))
            addpath(fullfile(sodaroot,'mo'))

            if sodaPar.verboseOutput
                disp('SODA: tools should now be available.')
            end

        catch
            if sodaPar.verboseOutput
                warning('SODA:add_soda_tools',['An error occurred ',...
                    'while trying to add ',char(10),...
                    'the SODA tools to the path.'])
            end
        end
    case '-help'
        if sodaPar.verboseOutput
            disp(['% soda -docinstall ',char(10),...
                  '%       adds some folders to the path, which contain helpful',char(10),...
                  '%       functions, and installs the documentation by writing ',char(10),...
                  '%       the info.xml file.',char(10)...
                  '%',char(10),...
                  '% soda -addtools ',char(10)...
                  '%       adds some folders to the path, which contain helpful',char(10),...
                  '%       functions.',char(10),...
                  '%',char(10),...
                  '% soda -help ',char(10),...
                  '%       shows this help.',char(10),...
                  '%',char(10),...
                  '% soda -rmpath',char(10),...
                  '%       removes the SODA directories from the path',char(10),...
                  '%',char(10),...
                  '% soda -showoptions',char(10),...
                  '%       lists the valid options for the SODA function.',char(10)...
                  '%',char(10),...
                  '% soda -root',char(10),...
                  '%       returns the root of the SODA toolbox.',char(10),...
                  '%',char(10),...
                  '% soda -update-version-file',char(10),...
                  '%       updates the version file which contains the',char(10)...
                  '%       Subversion revision number of the SODA software.',char(10),...
                  '%',char(10),...
                   ])
        end

    case '-rmpath'
        s=sodaroot;
        rmpath(s)
        rmpath(fullfile(s,'tools'))
        rmpath(fullfile(s,'visualization'))
        rmpath(fullfile(s,'enkf'))
        rmpath(fullfile(s,'ssp'))
        rmpath(fullfile(s,'mo'))
        clear s

        disp('SODA toolbox has successfully been removed from the path.')

    case '-showoptions'
        sodaVerifyFieldNames(sodaPar,'show')

    case '-root'
        a=mfilename('fullpath');
        Ix=findstr(a,[filesep,'soda']);
        s=a(1:Ix(end));
        varargout{1} = s;
        return

    case '-update-version-file'

        if ~(exist(fullfile(sodaroot,'version.txt'))==2)

            fid=fopen(fullfile(sodaroot,'version-helper.txt'),'rt');                
            C=textscan(fid,'%[^\n\r]',1);
            fclose(fid);

            fid=fopen(fullfile(sodaroot,'version.txt'),'wt');
            fprintf(fid,C{1}{1});
            fclose(fid);

        end


        chars = '1234567890abcdefghijklmnopqrstuvwxyz';
        nr = 100;
        nc = 60;
        Ix = 1+round(rand(1,nr*nc)*(numel(chars)-1));
        M = chars(Ix);
        M(nc:nc:nr*nc)=char(10);
        s = [char([10,10]),'SODA Toolbox for MATLAB version $LastChangedRevision$',...
            char([10,10,10,10,10]),M];

        fid=fopen(fullfile(sodaroot,'version-helper.txt'),'wt');
        fprintf(fid,s);
        fclose(fid);
        disp(['SODA: ',char(39),'version-helper.txt',char(39),' file ',...
            'written successfully. '])


    otherwise
        if sodaPar.verboseOutput
            warning('SODA:DocInstall',['For installing the documen',...
                'tation, type >>soda -docinstall'])
        end
end
