function varargout = sodaEstimateAcceptance(sodaPar,evalResults)

objSet = evalResults(:,sodaPar.paretoCol);

rMin = find(objSet==min(objSet));
if numel(rMin)>1
    rMin = rMin(1);
end

rMax = find(objSet==max(objSet));
if numel(rMax)>1
    rMax = rMax(1);
end

objPropChild = objSet(rMin);
lastDensFromSeq = objSet(rMax);

bestDensFromCompl = objSet(rMax);
worstDensFromCompl = objSet(rMin);

nTries = 100000;
acceptanceArray = [0,0,0];


for iTry = 1:nTries
    
    randUniDraw = rand;

    % metropolis annealing:
    switch sodaPar.optMethod
        case 'direct probability'

            densRatio = objPropChild/lastDensFromSeq;

            % determine the ratio between the best and worst evaluations 
            % in the current complex (\Gamma^{\itk}):
            bestWorstRatio = bestDensFromCompl/worstDensFromCompl;

            if densRatio > randUniDraw

                acceptanceArray(1,1) = acceptanceArray(1,1) + 1;
                
            elseif ((bestWorstRatio > sodaPar.thresholdL) & (lastDensFromSeq > worstDensFromCompl))

                acceptanceArray(1,2) = acceptanceArray(1,2) + 1;
                
            else

                acceptanceArray(1,3) = acceptanceArray(1,3) + 1;
            end

        case 'likelihood'

            densDiff = objPropChild - lastDensFromSeq;

            % determine the ratio between the best and worst evaluations 
            % in the current complex (\Gamma^{\itk}):
            bestWorstDiff = bestDensFromCompl-worstDensFromCompl;


            if densDiff>=log(randUniDraw)
                
                acceptanceArray(1,1) = acceptanceArray(1,1) + 1;
                
            elseif ((bestWorstDiff > log(sodaPar.thresholdL)) & (lastDensFromSeq > worstDensFromCompl))
                
                acceptanceArray(1,2) = acceptanceArray(1,2) + 1;
                
            else
                acceptanceArray(1,3) = acceptanceArray(1,3) + 1;
                
            end



        case 'error minimization'

            nMeasurements = sodaPar.nMeasurements;

            densRatio = (objPropChild/lastDensFromSeq)^(-nMeasurements.*(1+sodaPar.kurt)./2);

            % determine the ratio between the best and worst evaluations 
            % in the current complex (\Gamma^{\itk}):
            bestWorstRatio = (bestDensFromCompl/worstDensFromCompl)^(-nMeasurements*(1+sodaPar.kurt)/2);

            if densRatio > randUniDraw

                acceptanceArray(1,1) = acceptanceArray(1,1) + 1;

            elseif ((bestWorstRatio > sodaPar.thresholdL) & (lastDensFromSeq > worstDensFromCompl))

                acceptanceArray(1,2) = acceptanceArray(1,2) + 1;
                
            else

                acceptanceArray(1,3) = acceptanceArray(1,3) + 1;
                
            end
    end
end



if nargout==0
    accPerc = (acceptanceArray(1,1)/nTries)*100;
    str = ['The chance of accepting the worst parameter set from ',char(10)...
        'the initialization is approximately equal to ',...
        num2str(accPerc,'%.0f'),' %.'];

    disp(str)
    varargout = {};
    
elseif nargout==1
        
    varargout{1} = acceptanceArray;
    
else
    
    % do nothing
    
end