function [sequences,complexes,propChildren] = sodaRecalcPareto(sodaPar,sequences,complexes,propChildren)

% At this point we have objScores for sequences, complexes and
% propChildren. Now let's make a list that has all the
% objScores together so that we can re-calculate the
% pareto scores.

oldSeq = sequences;
oldCompl = complexes;
oldChildren = propChildren;

objScores = [];
for iCompl=1:sodaPar.nCompl
    objScores = [objScores;...
                 sequences(:,sodaPar.objCols,iCompl);...
                 complexes(:,sodaPar.objCols,iCompl);...
              propChildren(:,sodaPar.objCols,iCompl)];
end            

% recalc the PAreto scores:
paretoScores = -sodaCalcPareto(objScores,sodaPar.paretoMethod);


% redistribute the new pareto scores back into the original variables:
nRowsSeq = size(sequences,1);
nRowsCompl = size(complexes,1);
nRowsChildren = size(propChildren,1);

rowStart = 1;
rowEnd = nRowsSeq;

for iCompl=1:sodaPar.nCompl
    sequences(1:nRowsSeq,sodaPar.paretoCol,iCompl) = paretoScores(rowStart:rowEnd,1);
    rowStart = rowEnd + 1;
    rowEnd = rowStart + nRowsCompl - 1;

    complexes(1:nRowsCompl,sodaPar.paretoCol,iCompl) = paretoScores(rowStart:rowEnd,1);
    rowStart = rowEnd + 1;
    rowEnd = rowStart + nRowsChildren - 1;

    propChildren(1:nRowsChildren,sodaPar.paretoCol,iCompl) = paretoScores(rowStart:rowEnd,1);
    rowStart = rowEnd + 1;
    rowEnd = rowStart + nRowsSeq - 1;
end



newSeq = sequences;
newCompl = complexes;
newChildren = propChildren;

notTheParetoCol = [1:sodaPar.paretoCol-1,sodaPar.paretoCol+1];

if isequal(oldSeq(:,notTheParetoCol),newSeq(:,notTheParetoCol))&&...
        isequal(oldCompl(:,notTheParetoCol),newCompl(:,notTheParetoCol))&&...
        isequal(oldChildren(:,notTheParetoCol),newChildren(:,notTheParetoCol))
    % all ok
else
    error('something''s wrong')
end
    





