function mStatesPost = sodaUpdateStates(sodaPar,...
    mStatesPert,mStatesPost,stateInn,iIter)

nStatesKF = sodaPar.nStatesKF;
nMembers = sodaPar.nEnsembleMembers;


updatedState = mStatesPert(iIter+1,1:nStatesKF,1:nMembers)+...
    stateInn(iIter+1,1:nStatesKF,1:nMembers);



% check for consistency:

for iMember = 1:nMembers
    for iStateKF = 1:nStatesKF
        if updatedState(1,iStateKF,iMember) > sodaPar.stateSpaceHiBound(iStateKF)
            mStatesPost(iIter+1,iStateKF,iMember) = sodaPar.stateSpaceHiBound(iStateKF);
        elseif updatedState(1,iStateKF,iMember) < sodaPar.stateSpaceLoBound(iStateKF)
            mStatesPost(iIter+1,iStateKF,iMember) = sodaPar.stateSpaceLoBound(iStateKF);
        else
            mStatesPost(iIter+1,iStateKF,iMember) = updatedState(1,iStateKF,iMember);
        end
    end
end
