function [perturbedObs,sodaPar] = sodaPerturbObs(sodaPar,mConstants,perturbedObs,iIter)

nStatesKF = sodaPar.nStatesKF;
nMembers = sodaPar.nEnsembleMembers;

R = randn(nMembers,nStatesKF);
M = sodaPar.measErr;

% Err = randn(1,nStates,nMembers)*sodaPar.measErr;
Err = shiftdim([R*M]',-1);

X = mConstants{sodaPar.isMeas,2}(iIter+1,1:nStatesKF);
perturbedObs(iIter+1,1:nStatesKF,1:nMembers) = Err + repmat(X,[1,1,nMembers]);