if viz

    hFig = subplotScreen;
    set(hFig,'numbertitle','off','name','boundaries','inverthardcopy','off')

    [nRows,nCols,nLays] = size(nodes.ID);

    legendStrs = {};

    sizeOne = 5;

    conditions = {'~(nodes.type == -2 | nodes.type == -4 | nodes.beta ~= 0)','ok','internal',{'markersize',3,'markerfacecolor',[0,0,0],'markeredgecolor',[0,0,0]};...
                  'nodes.type == -2','om','seepage',{'markersize',sizeOne,'markerfacecolor','m','markeredgecolor','m'};...
                  'nodes.type == -4','oc','rain',{'markersize',sizeOne,'markerfacecolor','c','markeredgecolor','c'};...
                  'nodes.beta ~= 0','or','root',{'markersize',sizeOne,'markerfacecolor',[0,0.5,0],'markeredgecolor',[0,0.5,0]}};

    for iRow = 1:size(conditions,1)
        eval(['IO = ',conditions{iRow,1},';'])
        if any(IO(:))
            eval(['h=plot3(nodes.X(IO),nodes.Y(IO),nodes.Z(IO),',...
                char(39),conditions{iRow,2},char(39),');'])
            set(h,conditions{iRow,4}{:})
            hold on
            legendStrs{end+1} = conditions{iRow,3};
        end
    end


    if exist('transect','var')==1
        if numel(transect.x)==1
            tmp = ones(size(transect.y))*transect.x;
            xv = [tmp;flipud(tmp);tmp(1)];
            tmp = transect.y;
            yv = [tmp;flipud(tmp);tmp(1)];
            zv = [transect.zBottom;flipud(transect.zSurf);transect.zBottom(1)];
            clear tmp
            plot3(xv,yv,zv,'-r')
            legendStrs{end+1} = 'transect';
        end
    end



    if exist('monitor','var')==1
        if numel(monitor.x)==1
            hMonitor = plot3(monitor.x,monitor.y,monitor.z,'or');
            legendStrs{end+1} = 'monitor';
        end
    end

    axis image
    set(gca,'xtick',unique(nodes.X))
    set(gca,'ytick',unique(nodes.Y))
    set(gca,'ztick',[min(nodes.Z(:)),max(nodes.Z(:))])
    xlabel(['x [',swmsLengthUnits,']'])
    ylabel(['y [',swmsLengthUnits,']'])
    zlabel(['z [',swmsLengthUnits,']'])
    legend(legendStrs{:})
    view([38,30])

    set(hFig,'paperunits','centimeter')
    pos = get(hFig,'position');
    r = pos(3)/pos(4);
    maxWidth = 26;
    set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])



    if saveFigs
        print(gcf,'boundaries','-depsc','-r300','-loose')
    end



    clear legendStrs
    clear IO
    clear conditions
    clear sizeOne
    clear iRow
    clear h
    clear hTransect
    clear hMonitor

end % viz
