if viz

    if any(flow(:)<0)
        hFig = subplotScreen;
        set(hFig,'numbertitle','off','name','flow:negatives',...
            'InvertHardCopy','off','paperpositionmode','auto')
        [M,IX] = imagescCondensedFlow(flowTimes,flow,saveFigs,'negatives');

        set(hFig,'paperunits','centimeter')
        pos = get(hFig,'position');
        r = pos(3)/pos(4);
        maxWidth = 26;
        set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])


        if saveFigs
            print(hFig,'flow-positives','-depsc','-r300','-loose')
            print(hFig,'flow-positives','-dpng','-r300')    
        end

    else
        disp(['There''s no outflow at any point in time --skipping ',...
            'visualization of negative flow.'])
    end




    clear M 
    clear IX
    clear hFig
    clear pos
    clear maxWidth
    clear r



    if any(flow(:)>0)
        hFig = subplotScreen;
        set(hFig,'numbertitle','off','name','flow:positives',...
            'InvertHardCopy','off','paperpositionmode','auto')
        [M,IX] = imagescCondensedFlow(flowTimes,flow,saveFigs,'positives');

        set(hFig,'paperunits','centimeter')
        pos = get(hFig,'position');
        r = pos(3)/pos(4);
        maxWidth = 26;
        set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])


        if saveFigs
            print(hFig,'flow-negatives','-depsc','-r300','-loose')
            print(hFig,'flow-negatives','-dpng','-r300')    
        end

    else
        disp(['There''s no inflow at any point in time --skipping ',...
            'visualization of positive flow.'])
    end


    clear M 
    clear IX
    clear hFig
    clear pos
    clear maxWidth
    clear r
end % if viz




