if viz
    vizHeads = true;
    vertOffset = false;

    if visualizeTransects
        if exist('presHeads4D','var')==1
            % do nothing
        else
            if exist('presHeads','var')==1
                presHeads4D = conv2dto4d(presHeads,nRows,nCols,nLays,nodes);
            else
                try
                    [presHeads,presHeadTimes] = readOutput(pwd,'h.out',true);
                    presHeads4D = conv2dto4d(presHeads,nRows,nCols,nLays,nodes);
                catch
                    disp('Error processing pressure head information-- can''t plot transects.')
                end
            end
        end
        if ~any(isnan(presHeads4D(:)))
            zRes = 0.2;
            hFigPresHead = subplotScreen;
            set(hFigPresHead,'InvertHardCopy','off','paperpositionmode','auto')
            for iTime=1:size(presHeads4D,4)
                transectOf('PresHeads',nodes,presHeads4D,transect.x,transect.y,...
                    iTime,presHeadTimes,hFigPresHead,vertOffset,zRes)
                if saveFigs
                    print(hFigPresHead,['transectOfPresHeads_',sprintf('%03d',iTime)],'-depsc','-r300','-loose')
                    print(hFigPresHead,['transectOfPresHeads_',sprintf('%03d',iTime)],'-dpng','-r300')
                else
                    drawnow
                end
            end
        else
            disp('NaNs in pressure heads array. --Can''t plot.')
        end   % if ~any(isnan(presHeads(:)))
    end        


    clear vertOffset
    clear zRes
    clear hFigPresHead
    clear iTime
    clear vizHeads


end % if viz
