if viz 
    hFig = subplotScreen;
    set(hFig,'numbertitle','off','name','soil depth',...
        'paperpositionmode','auto','inverthardcopy','off')
    imagesc(nodes.X(1,:,1),...
            nodes.Y(:,1,1),...
            soilDepth)
    set(gca, 'ydir','normal')
    axis image
    title('soil depth [m]')
    xlabel('x [m]')
    ylabel('y [m]')

    colorbar


    set(hFig,'paperunits','centimeter')
    pos = get(hFig,'position');
    r = pos(3)/pos(4);
    maxWidth = 26;
    set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])



    if saveFigs
        print(hFig,'soil-depth','-depsc','-r300','-loose')
        print(hFig,'soil-depth','-dpng','-r300')    
    end



    clear r
    clear maxWidth
    clear pos

    
end % if viz    