if viz
    hFig = subplotScreen;

    set(hFig,'numbertitle','off','name','in-out',...
        'InvertHardCopy','off','paperpositionmode','auto')
    plot(flowTimes,sum(flow.*(flow>0),1),'.b-',...
         flowTimes,-sum(flow.*(flow<=0),1),'.r-')
    legend('total in','total out','Location','Best')
    xlabel(['time [',swmsTimeUnits,']'])
    ylabel(['cumulative flow [',swmsLengthUnits,'^3]'])


    set(hFig,'paperunits','centimeter')
    pos = get(hFig,'position');
    r = pos(3)/pos(4);
    maxWidth = 26;
    set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])



    if saveFigs
        print(gcf,'in-out','-depsc','-r300','-loose')
    end


    clear pos
    clear hFig
    clear maxWidth
    clear r
    
end % if viz