function [status,result] = swmsCallBat(str,showSTDOUT)

% disp('Starting executable')

switch str
    case 'old'
        if showSTDOUT
            system('SWMS_3D_OLD.bat')
        else
            [status,result]=system('SWMS_3D_OLD.bat');
        end
    case 'new'
        if showSTDOUT
            system('SWMS_3D_NEW.bat')
        else
            [status,result]=system('SWMS_3D_NEW.bat');
        end
    case '3'
        if showSTDOUT
            system('SWMS_3D_3.bat')
        else
            [status,result]=system('SWMS_3D_3.bat');
        end
    case '4'
        if showSTDOUT
            system('SWMS_3D_4.bat')
        else
            [status,result]=system('SWMS_3D_4.bat');
        end
    case '5'
        if showSTDOUT
            system('SWMS3D5.bat')
        else
            [status,result]=system('SWMS3D5.bat');
        end
    case '6'
        if showSTDOUT
            system('SWMS3D6.bat')
        else
            [status,result]=system('SWMS3D6.bat');
        end
    case '7'
        if showSTDOUT
            system('SWMS3D7.bat')
        else
            [status,result]=system('SWMS3D7.bat');
        end
    case '8'
        if showSTDOUT
            system('SWMS3D8.bat')
        else
            [status,result]=system('SWMS3D8.bat');
        end
    case '9'
        % this version has
        % (1) commented out Feddes et al values
        % (2) more detailed pressure head values in printed output
        % (3) limited output --only writes h.out and Q.out 
        % (4) commented out the normalization for beta
        if showSTDOUT
            system('SWMS3D9.bat')
        else
            [status,result]=system('SWMS3D9.bat');
        end
    case '10'
        % this version has
        % (1) commented out Feddes et al values
        % (2) more detailed pressure head values in printed output
        % (3) commented out the normalization for beta
        if showSTDOUT
            system('SWMS3D10.bat')
        else
            [status,result]=system('SWMS3D10.bat');
        end
    case '11'
        % this version should be the same as swms9 (which was lost), so it
        % has:
        % (1) commented out Feddes et al values
        % (2) more detailed pressure head values in printed output
        % (3) commented out the normalization for beta
        if showSTDOUT
            system('SWMS3D11.bat')
        else
            [status,result]=system('SWMS3D11.bat');
        end
    case '12'
        % this version is the same as swms11, but with a few minor changes:
        % (1) disabled writing of Q.out
        % (2) more detailed total stored water volume output in Balance.out
        % (3) more detailed cumulative flows in Cum_Q.out
        if showSTDOUT
            system('SWMS3D12.bat')
        else
            [status,result]=system('SWMS3D12.bat');
        end
        
    otherwise
        disp('unrecognized option')
end

if showSTDOUT
    status = 0;
    result = '';
end
