function objScore = objectivefun1(sodaPar,mStatesNOKF,vInnTrue,vSinkTrue)

iInit = 527;
iSink = 529;
iEnd = 531;

if ~strcmp(sodaPar.stateNamesNOKF{iInit},'vInit')
    error('wrong variable')
else
    vInitSim = mStatesNOKF(:,iInit);
end    

if ~strcmp(sodaPar.stateNamesNOKF{iSink},'vSink')
    error('wrong variable')
else
    vSinkSim = mStatesNOKF(:,iSink);
end    

if ~strcmp(sodaPar.stateNamesNOKF{iEnd},'vEnd')
    error('wrong variable')
else
    vEndSim = mStatesNOKF(:,iEnd);
end    

% correct these two volumes...
vEndSim(1,1) = vInitSim(2,1);
vInitSim(1,1) = NaN;

% ...before calulating the innovation volume:
vInnSim = repmat(NaN,[size(mStatesNOKF,1),1]);
vInnSim(1:end-1) = vInitSim(2:end)-vEndSim(1:end-1);


% make selection because vInnSim(end) is not defined...
% and aggregate because in the real world you wouldn't
% normally know the dynamics of vSink, just the total 
% volume that's missing from the water balance:
sim = sum(vInnSim(1:end-1) + vSinkSim(1:end-1));
obs = sum(vInnTrue(1:end-1) + vSinkTrue(1:end-1));

Dev = obs-sim;

objScore = sqrt(mean(Dev.^2));
