%
restoredefaultpath

clear
close all
clc

pwdStr = pwd;
addpath(fullfile(pwdStr,'fileio'))
addpath(fullfile(pwdStr,'viz'))
addpath(fullfile(pwdStr,'tools'))

%HORIZON = fullfile(pwdStr(1:min(findstr(pwdStr,filesep))),...
%    getenv('COMPUTERNAME'),'synchronized','horizon');
HORIZON = '.\..\..\..\..\';
addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../../20110930a/worker001/water-balance-components.mat','vInnTrue',...
    'vSinkTrue','vSeepTrue')


load('./../scemua-results-672-4-40-0.mat')

paretoOptimals = evalResults(find(evalResults(:,sodaPar.paretoCol)>-2),:);


[tmp0,tmp1,tmp2] = unique(paretoOptimals(:,sodaPar.parCols),'rows','first');
n=size(tmp0,1);
evalResultsPart=sortrows([paretoOptimals(tmp1,[1:1+sodaPar.nOptPars]),...
    repmat(NaN,[n,sodaPar.nObjs+1]),repmat(false,[n,1])],1);


for r = 1:size(evalResultsPart,1)
    
    if ~(evalResultsPart(r,1)==306)
        continue
    end

    if ~all(isnan(evalResultsPart(r,:))) && ~evalResultsPart(r,sodaPar.evalCol)
        % the model has not been evaluated with...
        % the parameters in the current row

        % read a line from the matrix containing rows of parameter vectors
        parVec = evalResultsPart(r,sodaPar.parCols);

        % call the ensemble Kalman Filter:
        if sodaPar.crashAndBurn
            [ensemblePred,mStatesInn,mStatesNOKF,sodaPar] = sodaEnKF(sodaPar,parVec);

            % compare the model result with the measurements and calculate the...
            % corresponding score according to an objective function:
            for iObj = 1:sodaPar.nObjs
                eval(sodaPar.objCallStrs{iObj})
                if isnan(objScore)
                    warning('SODA:objectiveScoreEqualsNaN',...
                        'Objective score is NaN')
                end
                evalResultsPart(r,sodaPar.objCols(1,iObj)) = objScore;
            end                
        else
            try
                [ensemblePred,mStatesInn,mStatesNOKF,sodaPar] = sodaEnKF(sodaPar,parVec);

                gridOfErrColorTwoSpace(sodaPar,ensemblePred-mConstants{1,2},parVec,...
                    'modeStr','error','yUnitStr','m','yLimMin',-0.14,'yLimMax',0.15,...
                    'xLabel','Time [hr]','yLabel',['model-observation',char(10),' residuals [m]'],...
                    'showParameters',false)


                set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
                print(gcf,['gridOfErr-',num2str(evalResultsPart(r,1),'%03d'),'.eps'],'-depsc2','-r300','-loose')
                print(gcf,['gridOfErr-',num2str(evalResultsPart(r,1),'%03d'),'.png'],'-dpng','-r300')


                % compare the model result with the measurements and calculate the...
                % corresponding score according to an objective function:
                for iObj = 1:sodaPar.nObjs
                    eval(sodaPar.objCallStrs{iObj})
                    if isnan(objScore)
                        warning('SODA:objectiveScoreEqualsNaN',...
                            'Objective score is NaN')
                    end
                    evalResultsPart(r,sodaPar.objCols(1,iObj)) = objScore;
                end                
            catch
                evalResultsPart(r,sodaPar.objCols) = sodaPar.badScore;
            end
        end

        % Set the 'model evaluated' flag to true:
        evalResultsPart(r,sodaPar.evalCol) = true;

    end
end

objScores = evalResultsPart(:,sodaPar.objCols);
goldbergs = sodaCalcPareto(objScores,'g')
