restoredefaultpath

clear
close all
clc

pwdStr = pwd;
Ix = findstr(pwdStr,filesep);
thisDisk = pwdStr(1:Ix(1));

addpath(fullfile(thisDisk,'horizon','matlab-tools'))

clear Ix 
clear pwdStr

load('./../job.mat')
load('./../innovations.mat')

[nTimes,nStatesKF,nMembers] = size(mStatesInn);

canvas.l = 0.20;
canvas.b = 0.12;
canvas.w = 0.53;
canvas.h = 0.85;


ax.l = 0.05;
ax.b = 0.05;
ax.w = 0.9;
ax.h = 0.9;

nRows = 15;
nCols = 7;

colWidth = canvas.w/nCols;
rowHeight = canvas.h/nRows;

axHandles = repmat(NaN,[nRows,nCols]);


timeDim = 1;
stateDim = 2;
memberDim = 3;
meanInn = mean(mStatesInn,memberDim);

cumMeanInn = reshape(sum(meanInn(2:nTimes,1:nStatesKF),timeDim),[nRows,nCols]);

% 
% figure
% imagesc(cumMeanInn)
% axis image
colormax = max(abs(cumMeanInn(:)));
color1 = [1,0,0];
color2 = [1,1,1];
color3 = [0,0.5,0];
cMap = interp1([-1;0;1]*colormax,[color1;color2;color3],linspace(-1*colormax,1*colormax,64));
% caxis([-1,1]*colormax)
% colormap(cMap);
% colorbar
% set(gca,'ydir','normal')



figNumber = 67445;
if ismember(figNumber,get(0,'Children'))
    close(figNumber)
end
subplotScreen(1,2,1,'figureNumber',figNumber)
axes('position',[canvas.l,canvas.b,canvas.w,canvas.h])
set(gca,'color','none','xtick',[],'ytick',[],'box','off',...
    'xcolor',[1,1,1]*0.8,'ycolor',[1,1,1]*0.8)
xlabel(['  ',char(10),'  ',char(10),'\bfalong-slope distance \rightarrow'],'color','k','fontsize',16)
ylabel(['\bfupslope distance \rightarrow',char(10),'  ',char(10),'  ',char(10),'  '],'color','k','fontsize',16)
xlim = [min(sodaPar.simPoints{1,2}(2:end)),max(sodaPar.simPoints{1,2}(2:end))];
ylim = [min(meanInn(:)),max(meanInn(:))];

for iRow=1:nRows
    for iCol=1:nCols
        
        L = canvas.l + (iCol-1)*colWidth + ax.l*colWidth;
        B = canvas.b + (iRow-1) * rowHeight + ax.b*rowHeight;
        W = ax.w*colWidth;
        H = ax.h*rowHeight;
        axHandles(iRow,iCol)=axes('position',[L,B,W,H]);

        
        stateIndex = (iCol-1)*nRows+iRow;
        plot(xlim,[0,0],'linestyle','--','color',[1,1,1]*0.4,'linewidth',1.5)
        hold on
        plot(sodaPar.simPoints{1,2}(2:end),meanInn(2:end,stateIndex),'linewidth',1.5);

        
        if ~(iCol==1&iRow==1)
            set(axHandles(iRow,iCol),'xticklabel','')
            set(axHandles(iRow,iCol),'yticklabel','')
        else
            xlabel('time [hr]','fontsize',12)
            ylabel('innovation [m]','fontsize',12)
        end
        set(axHandles(iRow,iCol),...
            'xlim',xlim,...
            'ylim',ylim,...
            'xtick',xlim,...
            'ytick',ylim,...
            'color',interp1([-1;0;1]*colormax,[color1;color2;color3],cumMeanInn(iRow,iCol)))
        
    end
end
    

L = canvas.l + (9-1)*colWidth;
B = canvas.b + (3-1) * rowHeight + ax.b*rowHeight;
W = ax.w*colWidth;
H = rowHeight*10 + ax.h*rowHeight;
colorbarAxes=axes('position',[L,B,W,H]);

cBarValues = linspace(max(cumMeanInn(:)),min(cumMeanInn(:)),64)';
imagesc(1,cBarValues,cBarValues)
caxis([-1,1]*colormax)
set(gca,'ydir','normal','xtick',[])
title(['cumulative',char(10),'mean innovation [m]'])
colormap(cMap)


set(gcf,'inverthardcopy','off','paperpositionmode','auto')

print('grid-of-innovations.png','-dpng','-r300')
print('grid-of-innovations.eps','-depsc2','-r300','-loose')


