%
restoredefaultpath

clear
close all
clc

pwdStr = pwd;
HORIZON = fullfile(pwdStr(1:min(findstr(pwdStr,filesep))),...
    getenv('COMPUTERNAME'),'synchronized','horizon');
addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../20110826a/worker001/Z.mat')





FS = 14;
MS = 5;
iSlice = 3;

nRows = 15;
nCols = 7;
nLays = 5;
res = 3.0; % meter
x = (0:nCols-1)*res;
y = (0:nRows-1)*res;
Y = repmat(y,[nLays,1]);
% Z = Y*tan((13/360)*(2*pi))+sort(1.0*rand(nLays,nRows),1);
Z = shiftdim(Z(:,iSlice,:),2)


iFig = newFigNumber(1001);
%sodaSubplotScreen(1,1,1,'figureNumber',iFig)
figure(iFig)
set(iFig,'pos',[ 138          81        1006         393])
axes('pos',[0.06,0.125,0.92,0.77])

h7 = patch([Y(1,:),fliplr(Y(end,:)),Y(1,1)],[Z(1,:),fliplr(Z(end,:)),Z(1,1)],'k');  % soil domain
hold on
h1 = plot(Y,Z,'-k',Y',Z','-k');
h2 = plot(Y(1,2:end),Z(1,2:end),'ok');                 % sink
h3 = plot(Y(end,2:end),Z(end,2:end),'ok');             % atmospheric
h4 = plot(Y(:,1),Z(:,1),'ok');                         % seepage face
h5 = plot(Y(2:end-1,2:end),Z(2:end-1,2:end),'ok');     % no flow
%h6 = plot([Y(end,1),Y(end,end)],[Z(end,1),Z(end,1)+Y(end,end)-Y(end,1)]+0.2,':'); % 45 degrees



set(h1,'linestyle','-','color',[0.3,0.3,0.3])
set(h2,'markerfacecolor',[1,1,1],'markeredgecolor',[0,0,0],'markersize',MS,'marker','s')       % sink 
set(h3,'markerfacecolor',[0.5,0.5,0.5],'markeredgecolor',[0.2,0.2,0.2],'markersize',MS,'marker','s') % atmospheric
set(h4,'markerfacecolor',[0,0,0],'markeredgecolor',[0,0,0],'markersize',MS,'marker','s') % seepage face
set(h5,'markerfacecolor',[1,1,1],'markeredgecolor',[0.2,0.2,0.2],'markersize',MS-2,'marker','o') % no flow
%set(h6,'marker','none','color',[0.7,0.7,0.7],'linestyle','--','linewidth',1)  % 45 degrees
set(h7,'marker','none','facecolor',[1,1,0],'edgecolor','k')  % soil domain


hLeg = legend([h3(1),h2(1),h4(1),h5(1),h7],'atmospheric','sink','seepage',...
    'internal','soil domain','location','SouthEast');
set(hLeg,'box','off')

axis image
set(gca,'xlim',[-0.25,9.25],'ylim',[1.5,4.75],'xtick',y,'ytick',[2,3,4],'xdir','normal','ticklength',[0.005,0.005])
set(gca,'layer','top')

xlabel('y: upslope distance [m]','fontsize',FS)
ylabel('z: vertical distance [m]','fontsize',FS)
title('transect','fontsize',FS)
set(iFig,'color','none')
set(iFig,'paperpositionmode','auto','inverthardcopy','off')
box on

print(iFig,'transect.png','-r300','-dpng')
print(iFig,'transect.eps','-r300','-depsc2','-loose')